/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.transporter.impl.soap;

import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.ebmwebsourcing.easycommons.research.util.cxf.Server;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import easybox.easyesb.ebmwebsourcing.com.exchange._1.EJaxbExchangeType;
import easybox.easyesb.ebmwebsourcing.com.exchange._1.EJaxbStatusType;
import easyesb.petalslink.com.transporter._1.PullRequest;
import easyesb.petalslink.com.transporter._1.PullResponse;
import easyesb.petalslink.com.transporter._1.PullWithId;
import easyesb.petalslink.com.transporter._1.PushRequest;
import easyesb.petalslink.com.transporter._1.PushResponse;
import easyesb.petalslink.com.transporter._1.TransportExceptionElement;
import easyesb.petalslink.com.transporter._1_0.TransportExceptionFault;
import easyesb.petalslink.com.transporter._1_0.Transporter;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;
import javax.jws.WebService;

@WebService(serviceName="transporterService", portName="TransporterImplPort", targetNamespace="http://com.petalslink.easyesb/transporter/1.0", wsdlLocation="wsdl/transporter10.wsdl", endpointInterface="easyesb.petalslink.com.transporter._1_0.Transporter")
public class Transporter_TransporterSOAP_Server
implements Transporter {
    private static final Logger log = Logger.getLogger(Transporter_TransporterSOAP_Server.class.getName());
    private Server endpoint;
    private static final int QUEUE_SIZE = 10000;
    private Map<String, BlockingQueue<EJaxbExchangeType>> exchangeQueuesMap = new HashMap<String, BlockingQueue<EJaxbExchangeType>>();

    public Transporter_TransporterSOAP_Server(String serverAddress) {
        log.finest("Starting transporter Server: " + serverAddress);
        this.endpoint = CXFHelper.getService((String)serverAddress, this.getClass(), (Object)this);
        this.start();
    }

    public String getAddress() {
        return this.endpoint.getAddress();
    }

    public void start() {
        this.endpoint.start();
    }

    public void stop() {
        this.endpoint.stop();
    }

    public boolean isStopped() {
        return this.endpoint.isStopped();
    }

    public PushResponse push(PushRequest parameters) {
        BlockingQueue<EJaxbExchangeType> exchangesQueue;
        if (parameters.getEndpointNodeName() == null) {
            log.warning("Endpoint node name cannot be null");
        }
        String queueName = ESBUtil.getURIWithoutQuery((URI)URI.create(parameters.getExchange().getDestinationReference())).toString();
        if (parameters.getExchange().getStatus().equals((Object)EJaxbStatusType.DONE) || parameters.getExchange().getStatus().equals((Object)EJaxbStatusType.FAULT)) {
            queueName = ESBUtil.getURIWithoutQuery((URI)URI.create(parameters.getExchange().getSourceReference())).toString();
        }
        if ((exchangesQueue = this.exchangeQueuesMap.get(queueName)) == null) {
            this.exchangeQueuesMap.put(queueName, new ArrayBlockingQueue(10000));
            exchangesQueue = this.exchangeQueuesMap.get(queueName);
        }
        if (exchangesQueue.remainingCapacity() == 0) {
            log.warning("The SOAP Transporter has reached its maximum capacity for the target component '" + parameters.getEndpointNodeName() + "'. The message exchange is rejected");
        }
        exchangesQueue.offer(parameters.getExchange());
        return new PushResponse();
    }

    public PullResponse pull(PullRequest parameters) throws TransportExceptionFault {
        PullResponse response = new PullResponse();
        EJaxbExchangeType res = null;
        if (parameters.getEndpointReference() == null) {
            TransportExceptionFault exception = new TransportExceptionFault("pullWithId: providerEndpoint Reference cannot be null", new TransportExceptionElement());
            exception.getFaultInfo().setErrorMsg("pullWithId: providerEndpoint Reference cannot be null");
            throw exception;
        }
        String providerReference = ESBUtil.getURIWithoutQuery((URI)URI.create(parameters.getEndpointReference())).toString();
        if (this.exchangeQueuesMap == null) {
            TransportExceptionFault exception = new TransportExceptionFault("pullWithId: the exchange queue map cannot be null", new TransportExceptionElement());
            exception.getFaultInfo().setErrorMsg("pullWithId: the exchange queue map cannot be null");
            throw exception;
        }
        BlockingQueue<EJaxbExchangeType> exchangesQueue = this.exchangeQueuesMap.get(providerReference);
        if (exchangesQueue != null) {
            res = (EJaxbExchangeType)exchangesQueue.poll();
        }
        response.setExchange(res);
        return response;
    }

    public PullResponse pullWithId(PullWithId parameters) throws TransportExceptionFault {
        if (parameters == null) {
            TransportExceptionFault exception = new TransportExceptionFault("pullWithId: parameters cannot be null", new TransportExceptionElement());
            exception.getFaultInfo().setErrorMsg("pullWithId: parameters cannot be null");
            throw exception;
        }
        if (parameters.getEndpointReference() == null) {
            TransportExceptionFault exception = new TransportExceptionFault("pullWithId: The provider endpoint cannot be null", new TransportExceptionElement());
            exception.getFaultInfo().setErrorMsg("pullWithId: The provider endpoint cannot be null");
            throw exception;
        }
        PullRequest pullRequest = new PullRequest();
        pullRequest.setEndpointReference(parameters.getEndpointReference());
        PullResponse response = this.pull(pullRequest);
        BlockingQueue<EJaxbExchangeType> exchangesQueue = this.exchangeQueuesMap.get(parameters.getEndpointReference());
        if (exchangesQueue == null) {
            TransportExceptionFault exception = new TransportExceptionFault("Impossible to find queue corresponding to this endpoint reference : " + parameters.getEndpointReference(), new TransportExceptionElement());
            exception.getFaultInfo().setErrorMsg("Impossible to find queue corresponding to this endpoint " + parameters.getEndpointReference());
            throw exception;
        }
        if (exchangesQueue != null && parameters.getUuid() != null) {
            EJaxbExchangeType first = null;
            while (response != null && response.getExchange() != null && !response.getExchange().getUuid().equals(parameters.getUuid()) && first != response.getExchange()) {
                if (first == null) {
                    first = response.getExchange();
                }
                exchangesQueue.offer(response.getExchange());
                response = this.pull(pullRequest);
            }
        }
        return response;
    }
}

