/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.transporter.impl.soap;

import java.net.URI;
import java.util.Map;
import java.util.UUID;

import javax.xml.namespace.QName;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportContext;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyesb.transporter.api.transport.Transporter;

import easybox.easyesb.ebmwebsourcing.com.exchange._1.EJaxbExchangeType;
import easyesb.petalslink.com.transporter._1.PullWithId;
import easyesb.petalslink.com.transporter._1.PushRequest;
import easyesb.petalslink.com.transporter._1_0.TransportExceptionFault;


@Scope("COMPOSITE")
@Service(value=Transporter.class,names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class SOAPTransporterImpl extends SCAComponentImpl implements Transporter {

	private Transporter_TransporterSOAP_Client client;

	private Transporter_TransporterSOAP_Server server;

	private SOAPTransportContext context = new SOAPTransportContext();


	public SOAPTransporterImpl() throws ExchangeException {
		client = new Transporter_TransporterSOAP_Client();
	}

	public SOAPTransporterImpl(QName endpoint, String address) throws ExchangeException {
		client = new Transporter_TransporterSOAP_Client();
		SOAPTransportContext context = new SOAPTransportContext();
		context.setNodeName(endpoint);
		context.setHttpAddress(address);
		this.setTransporterContext(context);
	}



	public TransportContext getTransporterContext() {
		return this.context;
	}

	public void setTransporterContext(TransportContext context) {
		this.context = (SOAPTransportContext) context;
		System.out.println("************************* server = " + server);
		if(server != null) {
			server.stop();
			server=null;
		}
		try {
			server = new Transporter_TransporterSOAP_Server(this.context.getHttpAddress());
		} catch(Throwable e) {
			System.out.println(" PB");
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}

	public Map<QName, String> getListOfTransporters() {
		return this.client.getListOfTransporters();
	}

	public Exchange pull(URI providerEndpointReference, QName nodeEndpointName) throws TransportException {
		Exchange res = null;
		EJaxbExchangeType exchange = null;
		try {
			if(providerEndpointReference == null) {
				throw new TransportException("provider endpoint reference cannot be null");	
			}
			if(nodeEndpointName == null) {
				throw new TransportException("node name cannot be null");	
			}
			if(this.context.getNodeName() == null) {
				throw new TransportException("node name cannot be null");	
			}
			if(nodeEndpointName.equals(this.context.getNodeName())) {
				easyesb.petalslink.com.transporter._1.PullRequest pullRequest = new easyesb.petalslink.com.transporter._1.PullRequest();
				pullRequest.setEndpointReference(providerEndpointReference.toString());
				easyesb.petalslink.com.transporter._1.PullResponse pullResponse = this.server.pull(pullRequest);
				exchange = pullResponse.getExchange();
			} else {

				String endpointAddress = this.client.getListOfTransporters().get(nodeEndpointName);
				if(endpointAddress == null) {
					throw new TransportException("Impossible to find transporter address to node:" + nodeEndpointName);
				}

				exchange = this.client.pull(providerEndpointReference, nodeEndpointName);
			}

			if(exchange != null) {
				//res = new ExchangeImpl(new URI("."), exchange, new NamespaceMapperImpl(), new SchemaLocatorImpl());
				//	res = this.xmlObjectFactory.create(Exchange.class);
				res = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().wrap(exchange, Exchange.class); 
			}
		} catch (TransportExceptionFault e) {
			throw new TransportException(e);
		}

		return res;
	}

	public Exchange pull(UUID uuid, URI providerEndpointName, QName nodeEndpointName) throws TransportException {
		Exchange res = null;
		EJaxbExchangeType exchange = null;
		try {
			if(providerEndpointName == null) {
				throw new TransportException("provider endpoint reference cannot be null");	
			}
			if(nodeEndpointName == null) {
				throw new TransportException("node name cannot be null");	
			}
			if(this.context.getNodeName() == null) {
				throw new TransportException("node name cannot be null");	
			}

			if(nodeEndpointName.equals(this.context.getNodeName())) {
				PullWithId _pullWithId_parameters = new PullWithId();
				_pullWithId_parameters.setUuid(uuid.toString());
				_pullWithId_parameters.setEndpointReference(providerEndpointName.toString());
				easyesb.petalslink.com.transporter._1.PullResponse pullResponse = this.server.pullWithId(_pullWithId_parameters);
				exchange = pullResponse.getExchange();
			} else {
				String endpointAddress = this.client.getListOfTransporters().get(nodeEndpointName);
				if(endpointAddress == null) {
					throw new TransportException("Impossible to find transporter address to node:" + nodeEndpointName);
				}
				exchange = this.client.pullWithId(uuid, providerEndpointName, nodeEndpointName);
			}

			if(exchange != null) {
				//				res = new ExchangeImpl(new URI("."), exchange, new NamespaceMapperImpl(), new SchemaLocatorImpl());
				//res = this.xmlObjectFactory.create(Exchange.class);
				res = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().wrap(exchange, Exchange.class); 
				//				res.setDestination(exchange.getDestination());
				//				res.setInterfaceName(exchange.getInterfaceName());
				//				res.setOperation(exchange.getOperation());
				//				res.setServiceName(exchange.getServiceName());
				//				res.setUuid(exchange.getUuid());	
			}
		} catch (TransportExceptionFault e) {
			throw new TransportException(e);
		}

		return res;
	}

	public void push(Exchange exchange, QName nodeNameToPush) throws TransportException {
		try {
			if(nodeNameToPush == null) {
				throw new TransportException("node name cannot be null");	
			}
			if(this.context.getNodeName() == null) {
				throw new TransportException("node name cannot be null");	
			}

			EJaxbExchangeType exch = (EJaxbExchangeType) ((Exchange)exchange).getInternalModel();


			if(nodeNameToPush.equals(this.context.getNodeName())) {
				PushRequest _push_parameters = new PushRequest();
				_push_parameters.setExchange(exch);
				_push_parameters.setEndpointNodeName(nodeNameToPush);
				this.server.push(_push_parameters);
			} else {
				this.client.push(nodeNameToPush, exch);
			}		
		} catch (TransportExceptionFault e) {
			throw new TransportException(e);
		}
	}


	public void stop() throws TransportException {
		this.server.stop();
	}

	public void start() throws TransportException {
		this.server.start();
	}

	@Override
	public boolean isStopped() {
		return this.server.isStopped();
	}
}
