/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyschema10.api.with;

import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easyschema10.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easyschema10.api.element.Attribute;
import com.ebmwebsourcing.easyschema10.api.with.WithAttributes;
import java.util.Arrays;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class WithAttributesTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_ATTRIBUTES = "expectedAttributes";

    public WithAttributesTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetAttributes() {
        WithAttributes attributes = (WithAttributes)this.newXmlObjectUnderTest();
        Object[] expectedAttributes = (Attribute[])this.getTestData(EXPECTED_ATTRIBUTES);
        Assert.assertArrayEquals((Object[])expectedAttributes, (Object[])attributes.getAttributes());
    }

    @Test
    public void testGetAttributeByName() {
        Attribute[] expectedAttributes;
        WithAttributes attributes = (WithAttributes)this.newXmlObjectUnderTest();
        for (Attribute expectedAttribute : expectedAttributes = (Attribute[])this.getTestData(EXPECTED_ATTRIBUTES)) {
            if (expectedAttribute.getName() == null) continue;
            Assert.assertEquals((Object)expectedAttribute, (Object)attributes.getAttributeByName(expectedAttribute.getName()));
        }
    }

    @Test
    public void testAddAttribute() {
        WithAttributes attributes = (WithAttributes)this.newXmlObjectUnderTest();
        LinkedList<Attribute> expectedAttributes = new LinkedList<Attribute>(Arrays.asList((Attribute[])this.getTestData(EXPECTED_ATTRIBUTES)));
        Attribute newAttribute = (Attribute)this.getXmlContext().getXmlObjectFactory().create(Attribute.class);
        newAttribute.setName("newAttributeName");
        newAttribute.setId("newAttributeId");
        expectedAttributes.add(newAttribute);
        attributes.addAttribute(newAttribute);
        Assert.assertEquals(expectedAttributes, Arrays.asList(attributes.getAttributes()));
    }

    @Test
    public void testRemoveAttribute() {
        WithAttributes attributes = (WithAttributes)this.newXmlObjectUnderTest();
        for (Attribute e : attributes.getAttributes()) {
            attributes.removeAttribute(e);
            Assert.assertFalse((boolean)Arrays.asList(attributes.getAttributes()).contains(e));
        }
    }

    @Test
    public void testClearAttributes() {
        WithAttributes attributes = (WithAttributes)this.newXmlObjectUnderTest();
        attributes.clearAttributes();
        Assert.assertEquals((long)0L, (long)attributes.getAttributes().length);
    }

    @Test
    public void testGetParentAfterAdding() {
        WithAttributes attributes = (WithAttributes)this.newXmlObjectUnderTest();
        Attribute newAttribute = (Attribute)this.getXmlContext().getXmlObjectFactory().create(Attribute.class);
        attributes.addAttribute(newAttribute);
        Assert.assertEquals((Object)attributes, (Object)newAttribute.getXmlObjectParent());
    }

    @Test
    public void testGetParentAfterRemoval() {
        WithAttributes attributes = (WithAttributes)this.newXmlObjectUnderTest();
        Attribute newAttribute = (Attribute)this.getXmlContext().getXmlObjectFactory().create(Attribute.class);
        attributes.addAttribute(newAttribute);
        attributes.removeAttribute(newAttribute);
        Assert.assertNull((Object)newAttribute.getXmlObjectParent());
    }
}

