/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyschema10.api.with;

import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easyschema10.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easyschema10.api.element.SimpleType;
import com.ebmwebsourcing.easyschema10.api.with.WithSimpleTypes;
import java.util.Arrays;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class WithSimpleTypesTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_SIMPLETYPES = "expectedSimpleTypes";

    public WithSimpleTypesTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetSimpleTypes() {
        WithSimpleTypes simpleTypes = (WithSimpleTypes)this.newXmlObjectUnderTest();
        Object[] expectedSimpleTypes = (SimpleType[])this.getTestData(EXPECTED_SIMPLETYPES);
        Assert.assertArrayEquals((Object[])expectedSimpleTypes, (Object[])simpleTypes.getSimpleTypes());
    }

    @Test
    public void testGetSimpleTypeByName() {
        SimpleType[] expectedSimpleTypes;
        WithSimpleTypes simpleTypes = (WithSimpleTypes)this.newXmlObjectUnderTest();
        for (SimpleType expectedSimpleType : expectedSimpleTypes = (SimpleType[])this.getTestData(EXPECTED_SIMPLETYPES)) {
            if (expectedSimpleType.getName() == null) continue;
            Assert.assertEquals((Object)expectedSimpleType, (Object)simpleTypes.getSimpleTypeByName(expectedSimpleType.getName()));
        }
    }

    @Test
    public void testAddSimpleType() {
        WithSimpleTypes simpleTypes = (WithSimpleTypes)this.newXmlObjectUnderTest();
        LinkedList<SimpleType> expectedSimpleTypes = new LinkedList<SimpleType>(Arrays.asList((SimpleType[])this.getTestData(EXPECTED_SIMPLETYPES)));
        SimpleType newSimpleType = (SimpleType)this.getXmlContext().getXmlObjectFactory().create(SimpleType.class);
        newSimpleType.setName("newSimpleTypeName");
        newSimpleType.setId("newSimpleTypeId");
        expectedSimpleTypes.add(newSimpleType);
        simpleTypes.addSimpleType(newSimpleType);
        Assert.assertEquals(expectedSimpleTypes, Arrays.asList(simpleTypes.getSimpleTypes()));
    }

    @Test
    public void testRemoveSimpleType() {
        WithSimpleTypes simpleTypes = (WithSimpleTypes)this.newXmlObjectUnderTest();
        for (SimpleType e : simpleTypes.getSimpleTypes()) {
            simpleTypes.removeSimpleType(e);
            Assert.assertFalse((boolean)Arrays.asList(simpleTypes.getSimpleTypes()).contains(e));
        }
    }

    @Test
    public void testClearSimpleTypes() {
        WithSimpleTypes simpleTypes = (WithSimpleTypes)this.newXmlObjectUnderTest();
        simpleTypes.clearSimpleTypes();
        Assert.assertEquals((long)0L, (long)simpleTypes.getSimpleTypes().length);
    }

    @Test
    public void testGetParentAfterAdding() {
        WithSimpleTypes simpleTypes = (WithSimpleTypes)this.newXmlObjectUnderTest();
        SimpleType newSimpleType = (SimpleType)this.getXmlContext().getXmlObjectFactory().create(SimpleType.class);
        simpleTypes.addSimpleType(newSimpleType);
        Assert.assertEquals((Object)simpleTypes, (Object)newSimpleType.getXmlObjectParent());
    }

    @Test
    public void testGetParentAfterRemoval() {
        WithSimpleTypes simpleTypes = (WithSimpleTypes)this.newXmlObjectUnderTest();
        SimpleType newSimpleType = (SimpleType)this.getXmlContext().getXmlObjectFactory().create(SimpleType.class);
        simpleTypes.addSimpleType(newSimpleType);
        simpleTypes.removeSimpleType(newSimpleType);
        Assert.assertNull((Object)newSimpleType.getXmlObjectParent());
    }
}

