/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyschema10.api;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easyschema10.api.SchemaOfSchemas;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyschema10.api.element.SimpleType;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;

public final class SchemaHelper {
    private SchemaHelper() {
    }

    private static final <X extends XmlObjectNode> X doSelectSingleXmlObjectNode(XmlObject xmlObjectContextNode, String xpathStr, Class<X> resultInterfaceClass) {
        XmlObjectXPathEvaluator xpathEvaluator = xmlObjectContextNode.getXmlContext().createXPathEvaluator();
        try {
            XmlObjectNode result = xpathEvaluator.selectSingleXmlObjectNode(xmlObjectContextNode, String.format(xpathStr, new Object[0]), resultInterfaceClass);
            return (X)result;
        }
        catch (XPathExpressionException xee) {
            throw new UncheckedException((Throwable)xee);
        }
    }

    private static <X extends XmlObjectNode> X[] doSelectXmlObjectNodes(XmlObject xmlObjectContextNode, String xpathStr, Class<X> resultInterfaceClass) {
        XmlObjectXPathEvaluator xpathEvaluator = xmlObjectContextNode.getXmlContext().createXPathEvaluator();
        try {
            XmlObjectNode[] result = xpathEvaluator.selectXmlObjectNodes(xmlObjectContextNode, String.format(xpathStr, new Object[0]), resultInterfaceClass);
            return result;
        }
        catch (XPathExpressionException xee) {
            throw new UncheckedException((Throwable)xee);
        }
    }

    public static Schema findParentSchema(XmlObject contextObject) {
        for (XmlObject current = contextObject; current != null; current = current.getXmlObjectParent()) {
            if (!(current instanceof Schema)) continue;
            return (Schema)current;
        }
        return null;
    }

    public static Type[] findTypes(XmlObject contextXmlObject) {
        return (Type[])SchemaHelper.doSelectXmlObjectNodes((XmlObject)contextXmlObject, (String)String.format("//*[(local-name() = 'simpleType') or (local-name() = 'complexType')][@name]", new Object[0]), Type.class);
    }

    public static Type findTypeByQName(XmlObject contextXmlObject, QName typeQName) {
        if ("http://www.w3.org/2001/XMLSchema".equals(typeQName.getNamespaceURI())) {
            SimpleType builtInType = SchemaOfSchemas.getSchema().getSimpleTypeByName(typeQName.getLocalPart());
            return builtInType;
        }
        return SchemaHelper.doSelectSingleXmlObjectNode(contextXmlObject, String.format("//*[(local-name() = 'simpleType') or (local-name() = 'complexType')][@name = '%s'][ancestor::*/@targetNamespace = '%s']", typeQName.getLocalPart(), typeQName.getNamespaceURI()), Type.class);
    }

    public static Element[] findElements(XmlObject contextXmlObject) {
        return (Element[])SchemaHelper.doSelectXmlObjectNodes((XmlObject)contextXmlObject, (String)String.format("//xs:element[@name][parent::xs:schema]", new Object[0]), Element.class);
    }

    public static Element findElementByQName(XmlObject contextXmlObject, QName elementQName) {
        return SchemaHelper.doSelectSingleXmlObjectNode(contextXmlObject, String.format("//xs:element[@name = '%s']" + (elementQName.getNamespaceURI().isEmpty() ? "" : "[ancestor::xs:schema/@targetNamespace = '%s']"), elementQName.getLocalPart(), elementQName.getNamespaceURI()), Element.class);
    }
}

