package com.ebmwebsourcing.easyschema10.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyschema10.api.element.SimpleType;
import com.ebmwebsourcing.easyschema10.api.type.Form;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import com.ebmwebsourcing.easyschema10.api.type.Use;

import easybox.org.w3._2001.xmlschema.EJaxbAttribute;
import easybox.org.w3._2001.xmlschema.EJaxbFormChoice;
import easybox.org.w3._2001.xmlschema.EJaxbLocalSimpleType;
import easybox.org.w3._2001.xmlschema.EJaxbTopLevelAttribute;

final class AttributeImpl extends AbstractAnnotatedImpl<EJaxbAttribute> implements
        com.ebmwebsourcing.easyschema10.api.element.Attribute {

    AttributeImpl(XmlContext xmlContext, EJaxbAttribute jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbAttribute> getCompliantModelClass() {
        if (getXmlObjectParent() instanceof SchemaImpl) {
            return EJaxbTopLevelAttribute.class;
        } else {
            return EJaxbAttribute.class;
        }
    }
    
    @Override
    public String getDefault() {
        return getModelObject().getDefault();
    }

    @Override
    public String getFixed() {
        return getModelObject().getFixed();
    }

    @Override
    public Form getForm() {
        EJaxbFormChoice jfc = getModelObject().getForm();
        if (jfc == null)
            return null;
        if (jfc.value().equals(EJaxbFormChoice.QUALIFIED)) {
            return Form.QUALIFIED;
        } else {
            return Form.UNQUALIFIED;
        }
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public QName getRef() {
        return getModelObject().getRef();
    }

    @Override
    public SimpleType getSimpleType() {
        if (getModelObject().getSimpleType() == null)
            return null;
        return getXmlContext().getXmlObjectFactory().wrap(getModelObject().getSimpleType(),
                SimpleTypeImpl.class);
    }

    @Override
    public QName getType() {
        return getModelObject().getType();
    }

    @Override
    public Use getUse() {
        return Use.valueOf(getModelObject().getUse().toUpperCase());
    }

    @Override
    public boolean hasDefault() {
        return getModelObject().getDefault() != null;
    }

    @Override
    public boolean hasFixed() {
        return getModelObject().getFixed() != null;
    }

    @Override
    public boolean hasForm() {
        return getModelObject().getForm() != null;
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public boolean hasRef() {
        return getModelObject().getRef() != null;
    }

    @Override
    public boolean hasSimpleType() {
        return getModelObject().getSimpleType() != null;
    }

    @Override
    public boolean hasType() {
        return getModelObject().getType() != null;
    }

    @Override
    public void setDefault(String value) {
        getModelObject().setDefault(value);
    }

    @Override
    public void setFixed(String fixed) {
        getModelObject().setFixed(fixed);
    }

    @Override
    public void setForm(Form form) {
        if (form == null) {
            getModelObject().setForm(null);
        } else if (form.equals(Form.QUALIFIED)) {
            getModelObject().setForm(EJaxbFormChoice.QUALIFIED);
        } else {
            getModelObject().setForm(EJaxbFormChoice.UNQUALIFIED);
        }
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    @Override
    public void setRef(QName ref) {
        getModelObject().setRef(ref);
    }

    @Override
    public void setSimpleType(SimpleType simpleType) {
        if (simpleType == null) {
            getModelObject().setSimpleType(null);
            return;
        }
        assert simpleType instanceof SimpleTypeImpl;
        SimpleTypeImpl simpleTypeImpl = (SimpleTypeImpl) simpleType;
        assert simpleTypeImpl.getModelObject() instanceof EJaxbLocalSimpleType;
        getModelObject().setSimpleType(
                (EJaxbLocalSimpleType) simpleTypeImpl.getModelObject());
    }

    @Override
    public void setType(QName qname) {
        getModelObject().setType(qname);
    }

    @Override
    public void setUse(Use use) {
        getModelObject().setUse(use.toString().toLowerCase());
    }

    
    public Type findType() {
        if (getSimpleType() != null) {
            return getSimpleType();
        } else if (getType() != null) {
            QName typeQName = getType();
            Type type = SchemaHelper.findTypeByQName(SchemaHelper.findParentSchema(this), typeQName);
            return type;
        }
        return null;
    }
    
    @Override
    public QName inferQName() {
        if (hasRef()) {
            return getRef();
        } else {
            Schema parentSchema = SchemaHelper.findParentSchema(this);
            String localPart = getName();
            if (localPart == null) return null;
            if (parentSchema == null) return new QName(localPart);
            return new QName(parentSchema.getTargetNamespace(), localPart);
        }
    }
    
}
