package com.ebmwebsourcing.easyschema10.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Sequence;
import com.ebmwebsourcing.easyschema10.api.type.ExtensionType;
import com.ebmwebsourcing.easyschema10.api.type.Type;

import easybox.org.w3._2001.xmlschema.EJaxbExtensionType;

final class ExtensionTypeImpl extends AbstractAnnotatedImpl<EJaxbExtensionType> implements
        ExtensionType {

    protected ExtensionTypeImpl(XmlContext xmlContext, EJaxbExtensionType jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbExtensionType> getCompliantModelClass() {
        return EJaxbExtensionType.class;
    }

    @Override
    public QName getBase() {
        return getModelObject().getBase();
    }

    @Override
    public void setBase(QName base) {
        getModelObject().setBase(base);
    }

    @Override
    public boolean hasSequence() {
        return getModelObject().getSequence() != null;
    }

    @Override
    public Sequence getSequence() {
        if (!hasSequence())
            return null;
        return getXmlContext().getXmlObjectFactory().wrap(getModelObject().getSequence(),
                SequenceImpl.class);
    }

    @Override
    public void setSequence(Sequence sequence) {
        if(sequence != null) {
            getModelObject().setSequence(((SequenceImpl) sequence).getModelObject());
        } else {
            getModelObject().setSequence(null);
        }
    }
    
    @Override
    public Type findBase() {
        QName base = getBase();
        if (base == null) return null;
        return SchemaHelper.findTypeByQName(SchemaHelper.findParentSchema(this), base);
    }

}
