package com.ebmwebsourcing.easyschema10.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;

import easybox.org.w3._2001.xmlschema.EJaxbImport;

final class ImportImpl extends AbstractAnnotatedImpl<EJaxbImport> implements
        com.ebmwebsourcing.easyschema10.api.element.Import {

    private XmlObject adoptedSchema;
    
    protected ImportImpl(XmlContext xmlContext, EJaxbImport jaxbModel) {
        super(xmlContext, jaxbModel);
        this.adoptedSchema = null;
    }

    
    
    @Override
    protected Class<? extends EJaxbImport> getCompliantModelClass() {
        return EJaxbImport.class;
    }
    

    @Override
    public String getNamespace() {
        if (!hasNamespace()) {
            return null;
        }
        return getModelObject().getNamespace();
    }

    @Override
    public String getSchemaLocation() {
        if (!hasSchemaLocation()) {
            return null;
        }
        return getModelObject().getSchemaLocation();
    }

    @Override
    public boolean hasNamespace() {
        return getModelObject().getNamespace() != null;
    }

    @Override
    public boolean hasSchemaLocation() {
        return getModelObject().getSchemaLocation() != null;
    }

    @Override
    public void setNamespace(String namespace) {
        getModelObject().setNamespace(namespace);
    }

    @Override
    public void setSchemaLocation(String schemaLocation) {
        getModelObject().setSchemaLocation(schemaLocation);
    }


    @Override
    public final XmlObject[] getXmlObjectAdoptedChildren() {
        if (adoptedSchema == null) { 
            adoptedSchema = adoptChild(getNamespace(), getSchemaLocation(), 0);
        }
        return new XmlObject[] { adoptedSchema };
    }
}
