/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyschema10.api.with;

import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easyschema10.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.with.WithElements;
import java.util.Arrays;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class WithElementsTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_ELEMENTS = "expectedElements";

    public WithElementsTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetElements() {
        WithElements elements = (WithElements)this.newXmlObjectUnderTest();
        Object[] expectedElements = (Element[])this.getTestData(EXPECTED_ELEMENTS);
        Assert.assertArrayEquals((Object[])expectedElements, (Object[])elements.getElements());
    }

    @Test
    public void testGetElementByName() {
        Element[] expectedElements;
        WithElements elements = (WithElements)this.newXmlObjectUnderTest();
        for (Element expectedElement : expectedElements = (Element[])this.getTestData(EXPECTED_ELEMENTS)) {
            if (expectedElement.getName() == null) continue;
            Assert.assertEquals((Object)expectedElement, (Object)elements.getElementByName(expectedElement.getName()));
        }
    }

    @Test
    public void testAddElement() {
        WithElements elements = (WithElements)this.newXmlObjectUnderTest();
        LinkedList<Element> expectedElements = new LinkedList<Element>(Arrays.asList((Element[])this.getTestData(EXPECTED_ELEMENTS)));
        Element newElement = (Element)this.getXmlContext().getXmlObjectFactory().create(Element.class);
        newElement.setName("newElementName");
        newElement.setId("newElementId");
        expectedElements.add(newElement);
        elements.addElement(newElement);
        Assert.assertEquals(expectedElements, Arrays.asList(elements.getElements()));
    }

    @Test
    public void testRemoveElement() {
        WithElements elements = (WithElements)this.newXmlObjectUnderTest();
        for (Element e : elements.getElements()) {
            elements.removeElement(e);
            Assert.assertFalse((boolean)Arrays.asList(elements.getElements()).contains(e));
        }
    }

    @Test
    public void testClearElements() {
        WithElements elements = (WithElements)this.newXmlObjectUnderTest();
        elements.clearElements();
        Assert.assertEquals((long)0L, (long)elements.getElements().length);
    }

    @Test
    public void testGetParentAfterAdding() {
        WithElements elements = (WithElements)this.newXmlObjectUnderTest();
        Element newElement = (Element)this.getXmlContext().getXmlObjectFactory().create(Element.class);
        elements.addElement(newElement);
        Assert.assertEquals((Object)elements, (Object)newElement.getXmlObjectParent());
    }

    @Test
    public void testGetParentAfterRemoval() {
        WithElements elements = (WithElements)this.newXmlObjectUnderTest();
        Element newElement = (Element)this.getXmlContext().getXmlObjectFactory().create(Element.class);
        elements.addElement(newElement);
        elements.removeElement(newElement);
        Assert.assertNull((Object)newElement.getXmlObjectParent());
    }
}

