package com.ebmwebsourcing.easyschema.xsd2xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easycommons.lang.ArrayHelper;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.ComplexType;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyschema10.api.type.Form;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import com.ebmwebsourcing.easyschema10.api.type.Use;

public class XSD2XMLImpl extends XSD2XML {

	@Override
	public Element generateElement(
			com.ebmwebsourcing.easyschema10.api.element.Element eIn,
			XmlObject typeHolderXmlObject, Object value) {
		Element res = null;
		if (eIn != null) {
			Map<com.ebmwebsourcing.easyschema10.api.type.Type, Object> values = null;
			if (value == null) {
				values = XSD2XML.createDefaultMap("");
			} else {
				values = XSD2XML.createDefaultMap(value);
			}
			res = this
			.generateElement(eIn, typeHolderXmlObject, values, SchemaHelper.findParentSchema(eIn
			).getElementFormDefault(), 1,
			false, false);
		}
		return res;
	}

	@Override
	public Element generateElement(
			com.ebmwebsourcing.easyschema10.api.element.Element eIn,
			XmlObject typeHolderXmlObject,
			Map<com.ebmwebsourcing.easyschema10.api.type.Type, Object> values,
			Form form, int minOccurs, boolean createOptionalElement,
			boolean createOptionalAttribute) {
		if (values == null) {
			values = createDefaultMap("");
		}

		// create element
		org.jdom.Element eOut = null;

		if (minOccurs == 0)
			return eOut;

		if (eIn.getXmlObjectParent() instanceof Schema) {
			// top level element
			eOut = new org.jdom.Element(eIn.inferQName().getLocalPart(), eIn
					.inferQName().getPrefix(), eIn.inferQName()
					.getNamespaceURI());
		} else {
			eOut = new org.jdom.Element(eIn.inferQName().getLocalPart());
		}

		if (form == Form.QUALIFIED) {
			eOut.setNamespace(org.jdom.Namespace.getNamespace(eIn.inferQName()
					.getPrefix(), eIn.inferQName().getNamespaceURI()));
		}

		Type eInType = eIn.findType();
		if (eInType == null) {
			eInType = SchemaHelper.findTypeByQName(typeHolderXmlObject,
					eIn.getType());
		}
		System.err.println("---" + eIn.getType());
		assert eInType != null;
		// if complextype, generate under element
		if (eInType instanceof ComplexType) {

			com.ebmwebsourcing.easyschema10.api.element.Element[] items = null;
			ComplexType complexType = (ComplexType) eInType;

			if (complexType.hasSequence()) {
				items = complexType.getSequence().getElements();
			} else if (complexType.hasAll()) {
				items = complexType.getAll().getElements();
			} else if (complexType.hasComplexContent()
					&& complexType.getComplexContent().hasExtensionType()) {
				// TODO: generate all inherited elements
				List<com.ebmwebsourcing.easyschema10.api.element.Element> l = getAllElementFindInAllInheritedParent(complexType
						.getComplexContent().getExtensionType().findBase());
				items = l
				.toArray(new com.ebmwebsourcing.easyschema10.api.element.Element[l
				                                                                 .size()]);

				// generate elements in extension
				if (complexType.getComplexContent().getExtensionType()
						.hasSequence()) {
					items = ArrayHelper.mergeArrays(items, complexType
							.getComplexContent().getExtensionType()
							.getSequence().getElements());
				}
			}

			if (items != null) {
				for (final com.ebmwebsourcing.easyschema10.api.element.Element item : items) {

					// is element
					if (item.getRef() == null) {
						// is an element
						final com.ebmwebsourcing.easyschema10.api.element.Element e = item;
						Form elmtFrom = null;
						if (e.getForm() != null) {
							elmtFrom = e.getForm();
						} else {
							elmtFrom = SchemaHelper.findParentSchema(e).getElementFormDefault();
						}
						int minOccursChildElmt = e.getMinOccurs();
						if (createOptionalElement == true
								&& minOccursChildElmt == 0) {
							minOccursChildElmt = 1;
						}
						Element child = (Element) this.generateElement(e,
								typeHolderXmlObject, values, elmtFrom,
								minOccursChildElmt, createOptionalElement,
								createOptionalAttribute);
						if (child != null) {
							eOut.addContent(child.detach());
						}
					} else {
						// is a ref on an element
						com.ebmwebsourcing.easyschema10.api.element.Element e = item
						.findRef();
						if (e != null) {
							Form elmtFrom = null;
							if (e.getForm() != null) {
								elmtFrom = e.getForm();
							} else {
								elmtFrom = form;
							}

							int minOccursChildElmt = e.getMinOccurs();
							if (createOptionalElement == true
									&& minOccursChildElmt == 0) {
								minOccursChildElmt = 1;
							}
							Element child = (Element) this.generateElement(e,
									typeHolderXmlObject, values, elmtFrom,
									minOccursChildElmt, createOptionalElement,
									createOptionalAttribute);
							if (child != null) {
								eOut.addContent(child.detach());
							}
						} else {
							throw new UncheckedException(
									"Impossible to find element corresponding to this reference: "
									+ item.getRef());
						}
					}
				}

				// handle attribute
				for (final com.ebmwebsourcing.easyschema10.api.element.Attribute attr : complexType
						.getAttributes()) {
					org.jdom.Attribute a = null;
					if (Use.REQUIRED.equals(attr.getUse())) {
						a = this.generateAttribute(eIn, attr, values);
					} else if (createOptionalAttribute == true) {
						a = this.generateAttribute(eIn, attr, values);
					}
					if (a != null) {

						eOut.setAttribute(a);
					}
				}

			}
		} else {
			// add value on the simpletype
			final String val = findValue(eInType, values);
			if ((val != null) && (!eIn.isNillable())) {
				eOut.setText(val);
			}
		}

		// add attribute to element
		Form attributeFormDefault = Form.UNQUALIFIED;
		Schema parentSchema = SchemaHelper.findParentSchema(eIn);
		if (parentSchema != null) {
			attributeFormDefault = parentSchema
			.getAttributeFormDefault();
		}
		List<Attribute> attrs = generateAttributes(eIn, values,
				attributeFormDefault, createOptionalAttribute);

		eOut.setAttributes(attrs);

		return eOut;
	}

	private List<com.ebmwebsourcing.easyschema10.api.element.Element> getAllElementFindInAllInheritedParent(
			com.ebmwebsourcing.easyschema10.api.type.Type base) {
		List<com.ebmwebsourcing.easyschema10.api.element.Element> res = new ArrayList<com.ebmwebsourcing.easyschema10.api.element.Element>();

		if (base instanceof ComplexType) {
			ComplexType ct = (ComplexType) base;
			if (ct.getAll() != null) {
				res.addAll(Arrays.asList(ct.getAll().getElements()));
			} else if (ct.getSequence() != null) {
				res.addAll(Arrays.asList(ct.getSequence().getElements()));
			} else if (ct.getComplexContent() != null
					&& ct.getComplexContent().getExtensionType() != null) {
				res.addAll(getAllElementFindInAllInheritedParent(ct
						.getComplexContent().getExtensionType().findBase()));
			}
		}

		return res;
	}

	private List<Attribute> generateAttributes(
			com.ebmwebsourcing.easyschema10.api.element.Element eIn,
			Map<com.ebmwebsourcing.easyschema10.api.type.Type, Object> values,
			Form attributeFormDefault, boolean createOptionalAttribute) {
		List<Attribute> res = new ArrayList<Attribute>();
		if (eIn.findType() instanceof ComplexType) {
			ComplexType ct = (ComplexType) eIn.findType();
			for (com.ebmwebsourcing.easyschema10.api.element.Attribute attr : ct
					.getAttributes()) {
				if (Use.REQUIRED.equals(attr.getUse())
						|| createOptionalAttribute == true) {
					Attribute a = null;
					String prefix = attr.inferQName().getPrefix();

					if ((prefix != null)
							&& !(attr.inferQName().getNamespaceURI().equals(eIn
									.inferQName().getNamespaceURI()))
									&& (attributeFormDefault == Form.QUALIFIED)) {
						a = new Attribute(attr.getName(), findValue(
								attr.findType(), values),
								Namespace.getNamespace(prefix, attr
										.inferQName().getNamespaceURI()));
					} else {
						a = new Attribute(attr.getName(), findValue(
								attr.findType(), values));
					}
					res.add(a);
				}

			}
		}
		return res;
	}

	private String findValue(
			com.ebmwebsourcing.easyschema10.api.type.Type key,
			final Map<com.ebmwebsourcing.easyschema10.api.type.Type, Object> values) {
		String res = null;
		if (values.get(key) != null) {
			res = values.get(key).toString();
		} else {
			res = "";
		}
		return res;
	}

	public org.jdom.Attribute generateAttribute(
			final com.ebmwebsourcing.easyschema10.api.element.Element eIn,
			final com.ebmwebsourcing.easyschema10.api.element.Attribute aIn,
			final Map<com.ebmwebsourcing.easyschema10.api.type.Type, Object> value) {
		org.jdom.Attribute attr = null;
		if (aIn.getName() != null) {
			String prefix = null;
			org.jdom.Namespace ns = null;
			String aInNamespaceURI = aIn.inferQName().getNamespaceURI();
			if (aInNamespaceURI != null) {
				String eInNamespaceURI = eIn.inferQName().getNamespaceURI();
				if(!aInNamespaceURI.equals(eInNamespaceURI)) {
					if (aIn.inferQName().getPrefix() != null && aIn.inferQName().getPrefix().trim().length() > 0) {
						prefix = aIn.inferQName().getPrefix();
						ns = org.jdom.Namespace.getNamespace(prefix,
								aInNamespaceURI);
					} else {
						prefix = eIn.getType().getPrefix();
						ns = org.jdom.Namespace.getNamespace(prefix,
								aInNamespaceURI);
					}
				} else {
					prefix = eIn.inferQName().getPrefix();
					ns = org.jdom.Namespace.getNamespace(prefix,
							aInNamespaceURI);
				}
			}
			if (SchemaHelper.findParentSchema(aIn).getAttributeFormDefault() == Form.QUALIFIED) {
				attr = new org.jdom.Attribute(aIn.getName(), findValue(
						aIn.findType(), value), ns);
			} else {
				attr = new org.jdom.Attribute(aIn.getName(), findValue(
						aIn.findType(), value), null);
			}
		}
		return attr;
	}

	@Override
	public String printXml(
			com.ebmwebsourcing.easyschema10.api.element.Element e, Object value) {
		final org.jdom.Element eOut = this.generateElement(e,
				SchemaHelper.findParentSchema(e), value);
		return new XMLOutputter(Format.getPrettyFormat()).outputString(eOut);
	}

	@Override
	public Element addMinOccursEqual0OrArrayElement(
			com.ebmwebsourcing.easyschema10.api.element.Element childDefinition,
			XmlObject typeHolderXmlObject, Element parentElement) {

		// verif if child is nillable or an array element
		int maxOcc = childDefinition.getMaxOccurs();

		Element child = null;
		if (childDefinition.getMinOccurs() == 0 || maxOcc > 1) {

			child = generateElement(childDefinition, typeHolderXmlObject,
					createDefaultMap(""), SchemaHelper.findParentSchema(childDefinition)
					.getElementFormDefault(), 1, false, true);

			// find parent complex type definition
			ComplexType parentType = this.findParentType(childDefinition);
			if (parentType.getSequence() != null) {
				addChildInGoodPlace(childDefinition, parentElement, child,
						parentType);
			} else if (parentType.getAll() != null) {
				addChildInGoodPlace(childDefinition, parentElement, child,
						parentType);
			} else {
				parentElement.addContent(child.detach());
			}
		} else {
			throw new UncheckedException("this element ("
					+ childDefinition.inferQName()
					+ ") is not an array or not minOccurs = 0");
		}

		return child;
	}

	@SuppressWarnings("unchecked")
	private void addChildInGoodPlace(
			com.ebmwebsourcing.easyschema10.api.element.Element childDefinition,
			Element parentElement, Element child, ComplexType parentType) {
		int index = 0;
		Element elmtInP = null;
		for (com.ebmwebsourcing.easyschema10.api.element.Element elmt : parentType
				.getSequence().getElements()) {
			if (elmt.inferQName().equals(childDefinition.inferQName())) {
				List<Element> arrayElmts = parentElement
				.getChildren(childDefinition.inferQName()
						.getLocalPart());
				if (arrayElmts == null || arrayElmts.size() == 0) {
					arrayElmts = parentElement.getChildren(childDefinition
							.inferQName().getLocalPart(), Namespace
							.getNamespace(childDefinition.inferQName()
									.getNamespaceURI()));
				}

				if (arrayElmts != null && arrayElmts.size() > 0) {
					arrayElmts.add((Element) child.detach());
				} else {
					parentElement.addContent(index, child.detach());
				}
				break;
			}
			elmtInP = parentElement.getChild(elmt.inferQName().getLocalPart());
			if (elmtInP == null) {
				elmtInP = parentElement.getChild(elmt.inferQName()
						.getLocalPart(), Namespace.getNamespace(elmt
								.inferQName().getNamespaceURI()));
			}
			if (elmtInP != null) {
				index++;
			}
		}
	}

	private ComplexType findParentType(XmlObject childDefinition) {
		ComplexType parentType = null;
		XmlObject parent = childDefinition.getXmlObjectParent();

		if (parent != null) {
			if (parent instanceof com.ebmwebsourcing.easyschema10.api.element.Element) {
				parentType = (ComplexType) ((com.ebmwebsourcing.easyschema10.api.element.Element) parent)
				.findType();
			} else if (parent instanceof ComplexType) {
				parentType = (ComplexType) parent;
			} else {
				parentType = findParentType(parent);
			}
		}

		return parentType;
	}

	@Override
	public String printXml(
			com.ebmwebsourcing.easyschema10.api.element.Element eIn,
			Map<com.ebmwebsourcing.easyschema10.api.type.Type, Object> values,
			boolean createOptionalElement, boolean createOptionalAttribute) /*
			 * throws
			 * SchemaException
			 */{
		Schema parentSchema = SchemaHelper.findParentSchema(eIn);
		final org.jdom.Element eOut = this.generateElement(eIn, parentSchema, values, 
				parentSchema.getElementFormDefault(), 1, createOptionalElement,
				createOptionalAttribute);
		return new XMLOutputter(Format.getPrettyFormat()).outputString(eOut);
	}

}
