/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyschema.xsd2xml.test;

import com.ebmwebsourcing.easybox.api.TestXmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easyschema.xsd2xml.XSD2XML;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.SchemaOfSchemas;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import java.net.URL;
import java.util.Calendar;
import java.util.Map;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.jdom.Element;
import org.junit.Test;

public class XSD2XMLTest {
    private String TARGET_NAMESPACE = "http://petals.ow2.org/";

    public QName cName(String name) {
        return new QName(this.TARGET_NAMESPACE, name);
    }

    @Test
    public void testReaderSchema() throws Exception {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/sample.xsd");
        Schema desc = (Schema)TestXmlContext.DEFAULT_XML_CONTEXT.createReader().readDocument(xsdUrl, Schema.class);
        Assert.assertNotNull((Object)desc);
        Type[] types = SchemaHelper.findTypes((XmlObject)desc);
        Assert.assertEquals((int)5, (int)types.length);
        Assert.assertEquals((String)"PurchaseOrderType", (String)types[0].inferQName().getLocalPart());
        Assert.assertEquals((String)"USAddress", (String)types[1].inferQName().getLocalPart());
        Assert.assertEquals((String)"Items", (String)types[2].inferQName().getLocalPart());
        Assert.assertEquals((String)"SKU", (String)types[3].inferQName().getLocalPart());
        com.ebmwebsourcing.easyschema10.api.element.Element[] elements = SchemaHelper.findElements((XmlObject)desc);
        Assert.assertEquals((int)2, (int)elements.length);
        Assert.assertEquals((String)"purchaseOrder", (String)elements[0].inferQName().getLocalPart());
        Assert.assertEquals((String)"comment", (String)elements[1].inferQName().getLocalPart());
    }

    @Test
    public void testImportSchema() throws Exception {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/reservationList.xsd");
        Schema desc = (Schema)TestXmlContext.DEFAULT_XML_CONTEXT.createReader().readDocument(xsdUrl, Schema.class);
        Assert.assertNotNull((Object)desc);
    }

    @Test
    public void testCreateElmtSchema() throws Exception {
        Schema schema = (Schema)TestXmlContext.DEFAULT_XML_CONTEXT.getXmlObjectFactory().create(Schema.class);
        schema.setTargetNamespace("http://petals.ow2.org/");
        com.ebmwebsourcing.easyschema10.api.element.Element elmt = (com.ebmwebsourcing.easyschema10.api.element.Element)TestXmlContext.DEFAULT_XML_CONTEXT.getXmlObjectFactory().create(com.ebmwebsourcing.easyschema10.api.element.Element.class);
        schema.addElement(elmt);
        elmt.setName("nbAssure");
        elmt.setType(new QName("http://www.w3.org/2001/XMLSchema", "int"));
        Element jDomElmt = XSD2XML.newInstance().generateElement(elmt, (XmlObject)SchemaHelper.findParentSchema((XmlObject)elmt), (Object)"?");
        Assert.assertNotNull((Object)jDomElmt);
    }

    @Test
    public void testCreateArraySchema() throws Exception {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/ManagerProcess.xsd");
        Schema desc = (Schema)TestXmlContext.DEFAULT_XML_CONTEXT.createReader().readDocument(xsdUrl, Schema.class);
        com.ebmwebsourcing.easyschema10.api.element.Element array = (com.ebmwebsourcing.easyschema10.api.element.Element)TestXmlContext.DEFAULT_XML_CONTEXT.getXmlObjectFactory().create(com.ebmwebsourcing.easyschema10.api.element.Element.class);
        array.setName("bidArray");
        array.setType(new QName("http://irit.contractnet.org", "ReceivedBids"));
        desc.addElement(array);
        System.out.println(XSD2XML.newInstance().printXml(array, (Object)"?"));
    }

    @Test
    public void testCreateMiseAJourSuiviCollecteElement() throws Exception {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/i_servicemajsuivi.xsd");
        Schema desc = (Schema)TestXmlContext.DEFAULT_XML_CONTEXT.createReader().readDocument(xsdUrl, Schema.class);
        com.ebmwebsourcing.easyschema10.api.element.Element miseAJourSuiviCollecte = desc.getElementByName("miseAJourSuiviCollecte");
        Assert.assertNotNull((Object)miseAJourSuiviCollecte);
        Assert.assertEquals((String)"miseAJourSuiviCollecte", (String)miseAJourSuiviCollecte.inferQName().getLocalPart());
    }

    @Test
    public void testRejectedBidElement() throws Exception {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/ContractorProcessAbstract.xsd");
        Schema desc = (Schema)TestXmlContext.DEFAULT_XML_CONTEXT.createReader().readDocument(xsdUrl, Schema.class);
        com.ebmwebsourcing.easyschema10.api.element.Element miseAJourSuiviCollecte = desc.getElementByName("ReceiveBidRejectRequest");
        Assert.assertNotNull((Object)miseAJourSuiviCollecte);
        Assert.assertEquals((String)"ReceiveBidRejectRequest", (String)miseAJourSuiviCollecte.inferQName().getLocalPart());
    }

    @Test
    public void testCreateGetPresenceElement() throws Exception {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/PresenceEnablerSEI-V1_0.xsd");
        Schema desc = (Schema)TestXmlContext.DEFAULT_XML_CONTEXT.createReader().readDocument(xsdUrl, Schema.class);
        com.ebmwebsourcing.easyschema10.api.element.Element getPresenceCollecte = desc.getElementByName("getPresence");
        Assert.assertNotNull((Object)getPresenceCollecte);
        Assert.assertEquals((String)"getPresence", (String)getPresenceCollecte.inferQName().getLocalPart());
        System.out.println(XSD2XML.newInstance().printXml(getPresenceCollecte, (Object)"?"));
    }

    @Test
    public void testAddDefaultValue() throws Exception {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/ContractorProcessAbstract.xsd");
        Schema desc = (Schema)TestXmlContext.DEFAULT_XML_CONTEXT.createReader().readDocument(xsdUrl, Schema.class);
        com.ebmwebsourcing.easyschema10.api.element.Element miseAJourSuiviCollecte = desc.getElementByName("ReceiveBidRejectRequest");
        Assert.assertNotNull((Object)miseAJourSuiviCollecte);
        Map map = XSD2XML.createDefaultMap((Object)"?");
        map.put(SchemaOfSchemas.getSchema().getSimpleTypeByName("int"), "0");
        map.put(SchemaOfSchemas.getSchema().getSimpleTypeByName("boolean"), "true");
        map.put(SchemaOfSchemas.getSchema().getSimpleTypeByName("dateTime"), Calendar.getInstance().getTime().toString());
        System.out.println(XSD2XML.newInstance().printXml(miseAJourSuiviCollecte, map, true, true));
    }

    @Test
    public void testAddDefaultValueWithEmptyMap() throws Exception {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/ContractorProcessAbstract.xsd");
        Schema desc = (Schema)TestXmlContext.DEFAULT_XML_CONTEXT.createReader().readDocument(xsdUrl, Schema.class);
        com.ebmwebsourcing.easyschema10.api.element.Element miseAJourSuiviCollecte = desc.getElementByName("ReceiveBidRejectRequest");
        Assert.assertNotNull((Object)miseAJourSuiviCollecte);
        System.out.println(XSD2XML.newInstance().printXml(miseAJourSuiviCollecte, null, true, true));
    }
}

