/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyschema.xsd2xml;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easycommons.lang.ArrayHelper;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easyschema.xsd2xml.XSD2XML;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.ComplexType;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyschema10.api.type.Form;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import com.ebmwebsourcing.easyschema10.api.type.Use;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XSD2XMLImpl
extends XSD2XML {
    @Override
    public Element generateElement(com.ebmwebsourcing.easyschema10.api.element.Element eIn, XmlObject typeHolderXmlObject, Object value) {
        Element res = null;
        if (eIn != null) {
            Map<Type, Object> values = null;
            values = value == null ? XSD2XML.createDefaultMap("") : XSD2XML.createDefaultMap(value);
            res = this.generateElement(eIn, typeHolderXmlObject, values, SchemaHelper.findParentSchema((XmlObject)eIn).getElementFormDefault(), 1, false, false);
        }
        return res;
    }

    @Override
    public Element generateElement(com.ebmwebsourcing.easyschema10.api.element.Element eIn, XmlObject typeHolderXmlObject, Map<Type, Object> values, Form form, int minOccurs, boolean createOptionalElement, boolean createOptionalAttribute) {
        Type eInType;
        if (values == null) {
            values = XSD2XMLImpl.createDefaultMap("");
        }
        Element eOut = null;
        if (minOccurs == 0) {
            return eOut;
        }
        eOut = eIn.getXmlObjectParent() instanceof Schema ? new Element(eIn.inferQName().getLocalPart(), eIn.inferQName().getPrefix(), eIn.inferQName().getNamespaceURI()) : new Element(eIn.inferQName().getLocalPart());
        if (form == Form.QUALIFIED) {
            eOut.setNamespace(Namespace.getNamespace((String)eIn.inferQName().getPrefix(), (String)eIn.inferQName().getNamespaceURI()));
        }
        if ((eInType = eIn.findType()) == null) {
            eInType = SchemaHelper.findTypeByQName((XmlObject)typeHolderXmlObject, (QName)eIn.getType());
        }
        assert (eInType != null);
        if (eInType instanceof ComplexType) {
            com.ebmwebsourcing.easyschema10.api.element.Element[] items = null;
            ComplexType complexType = (ComplexType)eInType;
            if (complexType.hasSequence()) {
                items = complexType.getSequence().getElements();
            } else if (complexType.hasAll()) {
                items = complexType.getAll().getElements();
            } else if (complexType.hasComplexContent() && complexType.getComplexContent().hasExtensionType()) {
                List<com.ebmwebsourcing.easyschema10.api.element.Element> l = this.getAllElementFindInAllInheritedParent(complexType.getComplexContent().getExtensionType().findBase());
                items = l.toArray(new com.ebmwebsourcing.easyschema10.api.element.Element[l.size()]);
                if (complexType.getComplexContent().getExtensionType().hasSequence()) {
                    items = (com.ebmwebsourcing.easyschema10.api.element.Element[])ArrayHelper.mergeArrays((Object[][])new com.ebmwebsourcing.easyschema10.api.element.Element[][]{items, complexType.getComplexContent().getExtensionType().getSequence().getElements()});
                }
            }
            if (items != null) {
                for (com.ebmwebsourcing.easyschema10.api.element.Element element : items) {
                    Element child;
                    int minOccursChildElmt;
                    Form elmtFrom;
                    com.ebmwebsourcing.easyschema10.api.element.Element e;
                    if (element.getRef() == null) {
                        e = element;
                        elmtFrom = null;
                        elmtFrom = e.getForm() != null ? e.getForm() : SchemaHelper.findParentSchema((XmlObject)e).getElementFormDefault();
                        minOccursChildElmt = e.getMinOccurs();
                        if (createOptionalElement && minOccursChildElmt == 0) {
                            minOccursChildElmt = 1;
                        }
                        if ((child = this.generateElement(e, typeHolderXmlObject, values, elmtFrom, minOccursChildElmt, createOptionalElement, createOptionalAttribute)) == null) continue;
                        eOut.addContent(child.detach());
                        continue;
                    }
                    e = element.findRef();
                    if (e != null) {
                        elmtFrom = null;
                        elmtFrom = e.getForm() != null ? e.getForm() : form;
                        minOccursChildElmt = e.getMinOccurs();
                        if (createOptionalElement && minOccursChildElmt == 0) {
                            minOccursChildElmt = 1;
                        }
                        if ((child = this.generateElement(e, typeHolderXmlObject, values, elmtFrom, minOccursChildElmt, createOptionalElement, createOptionalAttribute)) == null) continue;
                        eOut.addContent(child.detach());
                        continue;
                    }
                    throw new UncheckedException("Impossible to find element corresponding to this reference: " + element.getRef());
                }
                for (com.ebmwebsourcing.easyschema10.api.element.Element element : complexType.getAttributes()) {
                    Attribute a = null;
                    if (Use.REQUIRED.equals((Object)element.getUse())) {
                        a = this.generateAttribute(eIn, (com.ebmwebsourcing.easyschema10.api.element.Attribute)element, values);
                    } else if (createOptionalAttribute) {
                        a = this.generateAttribute(eIn, (com.ebmwebsourcing.easyschema10.api.element.Attribute)element, values);
                    }
                    if (a == null) continue;
                    eOut.setAttribute(a);
                }
            }
        } else {
            String val = this.findValue(eInType, values);
            if (val != null && !eIn.isNillable()) {
                eOut.setText(val);
            }
        }
        Form attributeFormDefault = Form.UNQUALIFIED;
        Schema parentSchema = SchemaHelper.findParentSchema((XmlObject)eIn);
        if (parentSchema != null) {
            attributeFormDefault = parentSchema.getAttributeFormDefault();
        }
        List<Attribute> attrs = this.generateAttributes(eIn, values, attributeFormDefault, createOptionalAttribute);
        eOut.setAttributes(attrs);
        return eOut;
    }

    private List<com.ebmwebsourcing.easyschema10.api.element.Element> getAllElementFindInAllInheritedParent(Type base) {
        ArrayList<com.ebmwebsourcing.easyschema10.api.element.Element> res = new ArrayList<com.ebmwebsourcing.easyschema10.api.element.Element>();
        if (base instanceof ComplexType) {
            ComplexType ct = (ComplexType)base;
            if (ct.getAll() != null) {
                res.addAll(Arrays.asList(ct.getAll().getElements()));
            } else if (ct.getSequence() != null) {
                res.addAll(Arrays.asList(ct.getSequence().getElements()));
            } else if (ct.getComplexContent() != null && ct.getComplexContent().getExtensionType() != null) {
                res.addAll(this.getAllElementFindInAllInheritedParent(ct.getComplexContent().getExtensionType().findBase()));
            }
        }
        return res;
    }

    private List<Attribute> generateAttributes(com.ebmwebsourcing.easyschema10.api.element.Element eIn, Map<Type, Object> values, Form attributeFormDefault, boolean createOptionalAttribute) {
        ArrayList<Attribute> res = new ArrayList<Attribute>();
        if (eIn.findType() instanceof ComplexType) {
            ComplexType ct = (ComplexType)eIn.findType();
            for (com.ebmwebsourcing.easyschema10.api.element.Attribute attr : ct.getAttributes()) {
                if (!Use.REQUIRED.equals((Object)attr.getUse()) && !createOptionalAttribute) continue;
                Attribute a = null;
                String prefix = attr.inferQName().getPrefix();
                a = prefix != null && !attr.inferQName().getNamespaceURI().equals(eIn.inferQName().getNamespaceURI()) && attributeFormDefault == Form.QUALIFIED ? new Attribute(attr.getName(), this.findValue(attr.findType(), values), Namespace.getNamespace((String)prefix, (String)attr.inferQName().getNamespaceURI())) : new Attribute(attr.getName(), this.findValue(attr.findType(), values));
                res.add(a);
            }
        }
        return res;
    }

    private String findValue(Type key, Map<Type, Object> values) {
        String res = null;
        res = values.get(key) != null ? values.get(key).toString() : "";
        return res;
    }

    public Attribute generateAttribute(com.ebmwebsourcing.easyschema10.api.element.Element eIn, com.ebmwebsourcing.easyschema10.api.element.Attribute aIn, Map<Type, Object> value) {
        Attribute attr = null;
        if (aIn.getName() != null) {
            String prefix = null;
            Namespace ns = null;
            String aInNamespaceURI = aIn.inferQName().getNamespaceURI();
            if (aInNamespaceURI != null) {
                String eInNamespaceURI = eIn.inferQName().getNamespaceURI();
                if (!aInNamespaceURI.equals(eInNamespaceURI)) {
                    if (aIn.inferQName().getPrefix() != null && aIn.inferQName().getPrefix().trim().length() > 0) {
                        prefix = aIn.inferQName().getPrefix();
                        ns = Namespace.getNamespace((String)prefix, (String)aInNamespaceURI);
                    } else {
                        prefix = eIn.getType().getPrefix();
                        ns = Namespace.getNamespace((String)prefix, (String)aInNamespaceURI);
                    }
                } else {
                    prefix = eIn.inferQName().getPrefix();
                    ns = Namespace.getNamespace((String)prefix, (String)aInNamespaceURI);
                }
            }
            attr = SchemaHelper.findParentSchema((XmlObject)aIn).getAttributeFormDefault() == Form.QUALIFIED ? new Attribute(aIn.getName(), this.findValue(aIn.findType(), value), ns) : new Attribute(aIn.getName(), this.findValue(aIn.findType(), value), null);
        }
        return attr;
    }

    @Override
    public String printXml(com.ebmwebsourcing.easyschema10.api.element.Element e, Object value) {
        Element eOut = this.generateElement(e, (XmlObject)SchemaHelper.findParentSchema((XmlObject)e), value);
        return new XMLOutputter(Format.getPrettyFormat()).outputString(eOut);
    }

    @Override
    public Element addMinOccursEqual0OrArrayElement(com.ebmwebsourcing.easyschema10.api.element.Element childDefinition, XmlObject typeHolderXmlObject, Element parentElement) {
        int maxOcc = childDefinition.getMaxOccurs();
        Element child = null;
        if (childDefinition.getMinOccurs() == 0 || maxOcc > 1) {
            child = this.generateElement(childDefinition, typeHolderXmlObject, XSD2XMLImpl.createDefaultMap(""), SchemaHelper.findParentSchema((XmlObject)childDefinition).getElementFormDefault(), 1, false, true);
            ComplexType parentType = this.findParentType((XmlObject)childDefinition);
            if (parentType.getSequence() != null) {
                this.addChildInGoodPlace(childDefinition, parentElement, child, parentType);
            } else if (parentType.getAll() != null) {
                this.addChildInGoodPlace(childDefinition, parentElement, child, parentType);
            } else {
                parentElement.addContent(child.detach());
            }
        } else {
            throw new UncheckedException("this element (" + childDefinition.inferQName() + ") is not an array or not minOccurs = 0");
        }
        return child;
    }

    private void addChildInGoodPlace(com.ebmwebsourcing.easyschema10.api.element.Element childDefinition, Element parentElement, Element child, ComplexType parentType) {
        int index = 0;
        Element elmtInP = null;
        for (com.ebmwebsourcing.easyschema10.api.element.Element elmt : parentType.getSequence().getElements()) {
            if (elmt.inferQName().equals(childDefinition.inferQName())) {
                List arrayElmts = parentElement.getChildren(childDefinition.inferQName().getLocalPart());
                if (arrayElmts == null || arrayElmts.size() == 0) {
                    arrayElmts = parentElement.getChildren(childDefinition.inferQName().getLocalPart(), Namespace.getNamespace((String)childDefinition.inferQName().getNamespaceURI()));
                }
                if (arrayElmts != null && arrayElmts.size() > 0) {
                    arrayElmts.add((Element)child.detach());
                    break;
                }
                parentElement.addContent(index, child.detach());
                break;
            }
            elmtInP = parentElement.getChild(elmt.inferQName().getLocalPart());
            if (elmtInP == null) {
                elmtInP = parentElement.getChild(elmt.inferQName().getLocalPart(), Namespace.getNamespace((String)elmt.inferQName().getNamespaceURI()));
            }
            if (elmtInP == null) continue;
            ++index;
        }
    }

    private ComplexType findParentType(XmlObject childDefinition) {
        ComplexType parentType = null;
        XmlObject parent = childDefinition.getXmlObjectParent();
        if (parent != null) {
            parentType = parent instanceof com.ebmwebsourcing.easyschema10.api.element.Element ? (ComplexType)((com.ebmwebsourcing.easyschema10.api.element.Element)parent).findType() : (parent instanceof ComplexType ? (ComplexType)parent : this.findParentType(parent));
        }
        return parentType;
    }

    @Override
    public String printXml(com.ebmwebsourcing.easyschema10.api.element.Element eIn, Map<Type, Object> values, boolean createOptionalElement, boolean createOptionalAttribute) {
        Schema parentSchema = SchemaHelper.findParentSchema((XmlObject)eIn);
        Element eOut = this.generateElement(eIn, (XmlObject)parentSchema, values, parentSchema.getElementFormDefault(), 1, createOptionalElement, createOptionalAttribute);
        return new XMLOutputter(Format.getPrettyFormat()).outputString(eOut);
    }
}

