/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easytools.plugin.release.impl;

import com.ebmwebsourcing.easytools.plugin.release.impl.Dependency;
import com.ebmwebsourcing.easytools.plugin.release.impl.DependencyComparator;
import com.ebmwebsourcing.easytools.plugin.release.impl.TreeMojo;
import com.ebmwebsourcing.easytools.plugin.release.impl.util.OSValidator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class ReleaseMojo
extends AbstractMojo {
    private static Logger log = Logger.getLogger(ReleaseMojo.class.getName());
    private MavenProject project = null;
    protected String version = null;
    protected boolean testSkip = false;
    protected boolean javadoc = false;
    private Map<ReferenceTag, Map<Dependency.Type, List<Dependency>>> dependenciesMap = new HashMap<ReferenceTag, Map<Dependency.Type, List<Dependency>>>();
    private TreeMojo tree = new TreeMojo();
    private List<String> propertyTagContainingSnapshotVersion = new ArrayList<String>();

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void execute() throws MojoExecutionException {
        try {
            if (this.project != null) {
                if (this.version == null) {
                    throw new MojoExecutionException("Version cannot be null!!!");
                }
                this.tree.setProject(this.getProject());
                this.tree.validBaseDir();
                System.out.println("start release on projet: " + this.project.getArtifactId());
                MavenProject effectiveProject = this.project;
                ArrayList<Dependency> allDependencies = new ArrayList<Dependency>();
                allDependencies.addAll(this.tree.getAllDependencies(effectiveProject));
                System.out.println("zzozozozozozozozozzooz: " + URI.create(this.tree.getBaseDir().toString() + "/pom.xml"));
                allDependencies.add(new Dependency(URI.create(this.tree.getBaseDir().toString() + "/pom.xml")));
                for (Dependency dep : allDependencies) {
                    System.out.println("dep: " + dep.getArtifactId());
                }
                this.sortAllDependencies(allDependencies);
                this.verifyIfTestIsRequired(allDependencies);
                for (Dependency dep : allDependencies) {
                    this.changeVersion(dep);
                    this.changeDistributionManagementAndAddReleaseProperty(dep);
                }
                for (Dependency dependence : this.dependenciesMap.get((Object)ReferenceTag.BOOTSTRAP).get((Object)Dependency.Type.POM)) {
                    this.process(dependence);
                }
                for (Dependency dependence : this.dependenciesMap.get((Object)ReferenceTag.BOOTSTRAP).get((Object)Dependency.Type.JAR)) {
                    this.process(dependence);
                }
                System.out.println("*************************** List of pom of stable: \n" + this.dependenciesMap.get((Object)ReferenceTag.STABLE).get((Object)Dependency.Type.POM));
                for (Dependency dependence : this.dependenciesMap.get((Object)ReferenceTag.STABLE).get((Object)Dependency.Type.POM)) {
                    this.process(dependence);
                }
                System.out.println("*************************** List of jar of stable: \n" + this.dependenciesMap.get((Object)ReferenceTag.STABLE).get((Object)Dependency.Type.JAR));
                for (Dependency dependence : this.dependenciesMap.get((Object)ReferenceTag.STABLE).get((Object)Dependency.Type.JAR)) {
                    this.process(dependence);
                }
                System.out.println("*************************** List of pom of cooking: \n" + this.dependenciesMap.get((Object)ReferenceTag.COOKING).get((Object)Dependency.Type.POM));
                for (Dependency dependence : this.dependenciesMap.get((Object)ReferenceTag.COOKING).get((Object)Dependency.Type.POM)) {
                    this.process(dependence);
                }
                System.out.println("*************************** List of jar of cooking: \n" + this.dependenciesMap.get((Object)ReferenceTag.COOKING).get((Object)Dependency.Type.JAR));
                for (Dependency dependence : this.dependenciesMap.get((Object)ReferenceTag.COOKING).get((Object)Dependency.Type.JAR)) {
                    this.process(dependence);
                }
                System.out.println("*************************** List of pom of prod: \n" + this.dependenciesMap.get((Object)ReferenceTag.PROD).get((Object)Dependency.Type.POM));
                for (Dependency dependence : this.dependenciesMap.get((Object)ReferenceTag.PROD).get((Object)Dependency.Type.POM)) {
                    this.process(dependence);
                }
                System.out.println("*************************** List of jar of prod: \n" + this.dependenciesMap.get((Object)ReferenceTag.PROD).get((Object)Dependency.Type.JAR));
                for (Dependency dependence : this.dependenciesMap.get((Object)ReferenceTag.PROD).get((Object)Dependency.Type.JAR)) {
                    this.process(dependence);
                }
                System.out.println("*************************** List of pom of experimental: \n" + this.dependenciesMap.get((Object)ReferenceTag.EXPERIMENTAL).get((Object)Dependency.Type.POM));
                for (Dependency dependence : this.dependenciesMap.get((Object)ReferenceTag.EXPERIMENTAL).get((Object)Dependency.Type.POM)) {
                    this.process(dependence);
                }
                System.out.println("*************************** List of jar of experimental: \n" + this.dependenciesMap.get((Object)ReferenceTag.EXPERIMENTAL).get((Object)Dependency.Type.JAR));
                for (Dependency dependence : this.dependenciesMap.get((Object)ReferenceTag.EXPERIMENTAL).get((Object)Dependency.Type.JAR)) {
                    this.process(dependence);
                }
                System.out.println("*************************** List of pom of commons: \n" + this.dependenciesMap.get((Object)ReferenceTag.COMMONS).get((Object)Dependency.Type.POM));
                for (Dependency dependence : this.dependenciesMap.get((Object)ReferenceTag.COMMONS).get((Object)Dependency.Type.POM)) {
                    this.process(dependence);
                }
                System.out.println("*************************** List of jar of commons: \n" + this.dependenciesMap.get((Object)ReferenceTag.COMMONS).get((Object)Dependency.Type.JAR));
                for (Dependency dependence : this.dependenciesMap.get((Object)ReferenceTag.COMMONS).get((Object)Dependency.Type.JAR)) {
                    this.process(dependence);
                }
                System.out.println("*************************** List of pom of commons: \n" + this.dependenciesMap.get((Object)ReferenceTag.PROJECTS).get((Object)Dependency.Type.POM));
                for (Dependency dependence : this.dependenciesMap.get((Object)ReferenceTag.PROJECTS).get((Object)Dependency.Type.POM)) {
                    this.process(dependence);
                }
                System.out.println("*************************** List of jar of commons: \n" + this.dependenciesMap.get((Object)ReferenceTag.PROJECTS).get((Object)Dependency.Type.JAR));
                for (Dependency dependence : this.dependenciesMap.get((Object)ReferenceTag.PROJECTS).get((Object)Dependency.Type.JAR)) {
                    this.process(dependence);
                }
                System.out.println("Release " + this.version + " Sucessfull !!!!!!!!!!!!!!!!! => Congratulation");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void changeDistributionManagementAndAddReleaseProperty(Dependency dep) {
        if (dep.getProjectModel().getDistributionManagement() != null) {
            DistributionManagement dm = new DistributionManagement();
            DeploymentRepository dr = new DeploymentRepository();
            dr.setId("ebmws-research-public.release");
            dr.setName("eBMWS Maven 2 Research Releases Public Repository");
            dr.setUrl(URI.create(this.tree.getBaseDir().toString() + "target/release/m2/repository/").toString());
            dm.setRepository(dr);
            dep.getProjectModel().setDistributionManagement(dm);
            dep.getProjectModel().getProperties().put("java.compiler.showWarnings", "false");
            dep.getProjectModel().getProperties().put("java.compiler.debug", "false");
            dep.getProjectModel().getProperties().put("java.compiler.optimize", "true");
        }
    }

    private void verifyIfTestIsRequired(List<Dependency> allDependencies) {
        for (Dependency dep : allDependencies) {
            for (org.apache.maven.model.Dependency d : dep.getProjectModel().getDependencies()) {
                Dependency testDep;
                if (d == null || d.getVersion() == null || !d.getVersion().contains("SNAPSHOT") || d.getType() == null || !d.getType().equals("test-jar") || (testDep = this.findDependency(d, allDependencies)) == null) continue;
                testDep.setTestIsRequired(true);
                System.out.println("Test is required for: " + testDep.getArtifactId());
            }
            if (dep.getGroupId().equals("com.ebmwebsourcing.easycommons") && dep.getArtifactId().equals("easycommons-sca-api")) {
                dep.setTestIsRequired(true);
            }
            if (dep.getGroupId().equals("com.ebmwebsourcing.easycommons") && dep.getArtifactId().equals("easycommons-sca-impl")) {
                dep.setTestIsRequired(true);
            }
            if (dep.getArtifactId().contains("easybox")) {
                dep.setTestIsRequired(true);
            }
            if (dep.getArtifactId().contains("easycommons-util")) {
                dep.setTestIsRequired(true);
            }
            if (dep.getArtifactId().contains("bpmn20-api")) {
                dep.setTestIsRequired(true);
            }
            if (!dep.getArtifactId().contains("bpmn20-impl")) continue;
            dep.setTestIsRequired(true);
        }
    }

    private Dependency findDependency(org.apache.maven.model.Dependency d, List<Dependency> allDependencies) {
        if (d != null) {
            for (Dependency d1 : allDependencies) {
                if (!d1.getGroupId().equals(d.getGroupId()) || !d1.getArtifactId().equals(d.getArtifactId()) || !d1.getVersion().equals(d.getVersion())) continue;
                return d1;
            }
        }
        return null;
    }

    public void process(Dependency dependence) throws IOException, MojoExecutionException {
        URI pomUri = URI.create(dependence.getLocation().toString().replace("pom.xml", "pom-" + this.version + ".xml"));
        dependence.write(pomUri);
        File destination = new File(URI.create(this.tree.getBaseDir().toString() + "target/release/m2/repository/"));
        destination.mkdirs();
        String finalName = null;
        if (this.findType(dependence) == Dependency.Type.JAR) {
            finalName = dependence.getArtifactId() + "-" + this.version + ".jar";
        } else if (this.findType(dependence) == Dependency.Type.POM) {
            finalName = "pom.xml";
        } else {
            throw new MojoExecutionException("Packaging type not supported: " + dependence.getProjectModel().getPackaging());
        }
        this.installFile(dependence);
    }

    private void sortAllDependencies(List<Dependency> allDependencies) throws MojoExecutionException {
        this.dependenciesMap.clear();
        HashMap bootStrapMap = new HashMap();
        bootStrapMap.put(Dependency.Type.POM, new ArrayList());
        bootStrapMap.put(Dependency.Type.JAR, new ArrayList());
        this.dependenciesMap.put(ReferenceTag.BOOTSTRAP, bootStrapMap);
        HashMap stableMap = new HashMap();
        stableMap.put(Dependency.Type.POM, new ArrayList());
        stableMap.put(Dependency.Type.JAR, new ArrayList());
        this.dependenciesMap.put(ReferenceTag.STABLE, stableMap);
        HashMap cookingMap = new HashMap();
        cookingMap.put(Dependency.Type.POM, new ArrayList());
        cookingMap.put(Dependency.Type.JAR, new ArrayList());
        this.dependenciesMap.put(ReferenceTag.COOKING, cookingMap);
        HashMap prodMap = new HashMap();
        prodMap.put(Dependency.Type.POM, new ArrayList());
        prodMap.put(Dependency.Type.JAR, new ArrayList());
        this.dependenciesMap.put(ReferenceTag.PROD, prodMap);
        HashMap experimentalMap = new HashMap();
        experimentalMap.put(Dependency.Type.POM, new ArrayList());
        experimentalMap.put(Dependency.Type.JAR, new ArrayList());
        this.dependenciesMap.put(ReferenceTag.EXPERIMENTAL, experimentalMap);
        HashMap commonsResearchMap = new HashMap();
        commonsResearchMap.put(Dependency.Type.POM, new ArrayList());
        commonsResearchMap.put(Dependency.Type.JAR, new ArrayList());
        this.dependenciesMap.put(ReferenceTag.COMMONS, commonsResearchMap);
        HashMap projectsResearchMap = new HashMap();
        projectsResearchMap.put(Dependency.Type.POM, new ArrayList());
        projectsResearchMap.put(Dependency.Type.JAR, new ArrayList());
        this.dependenciesMap.put(ReferenceTag.PROJECTS, projectsResearchMap);
        for (Dependency d : allDependencies) {
            ReferenceTag tag = this.findReferenceTag(d);
            Dependency.Type type = this.findType(d);
            this.setDependencyInMap(tag, type, d);
        }
        DependencyComparator dc = new DependencyComparator(allDependencies);
        System.out.println("sort bootstrap");
        Collections.sort(this.dependenciesMap.get((Object)ReferenceTag.BOOTSTRAP).get((Object)Dependency.Type.POM), dc);
        this.sort(this.dependenciesMap.get((Object)ReferenceTag.BOOTSTRAP).get((Object)Dependency.Type.JAR), dc);
        System.out.println("sort stable");
        Collections.sort(this.dependenciesMap.get((Object)ReferenceTag.STABLE).get((Object)Dependency.Type.POM), dc);
        this.sort(this.dependenciesMap.get((Object)ReferenceTag.STABLE).get((Object)Dependency.Type.JAR), dc);
        System.out.println("sort cooking");
        Collections.sort(this.dependenciesMap.get((Object)ReferenceTag.COOKING).get((Object)Dependency.Type.POM), dc);
        this.sort(this.dependenciesMap.get((Object)ReferenceTag.COOKING).get((Object)Dependency.Type.JAR), dc);
        System.out.println("sort prod");
        Collections.sort(this.dependenciesMap.get((Object)ReferenceTag.PROD).get((Object)Dependency.Type.POM), dc);
        this.sort(this.dependenciesMap.get((Object)ReferenceTag.PROD).get((Object)Dependency.Type.JAR), dc);
        System.out.println("sort experimental");
        System.out.println("sort experimental pom");
        Collections.sort(this.dependenciesMap.get((Object)ReferenceTag.EXPERIMENTAL).get((Object)Dependency.Type.POM), dc);
        System.out.println("sort experimental jar");
        this.sort(this.dependenciesMap.get((Object)ReferenceTag.EXPERIMENTAL).get((Object)Dependency.Type.JAR), dc);
        System.out.println("sort commons");
        Collections.sort(this.dependenciesMap.get((Object)ReferenceTag.COMMONS).get((Object)Dependency.Type.POM), dc);
        this.sort(this.dependenciesMap.get((Object)ReferenceTag.COMMONS).get((Object)Dependency.Type.JAR), dc);
        System.out.println("sort projects");
        Collections.sort(this.dependenciesMap.get((Object)ReferenceTag.PROJECTS).get((Object)Dependency.Type.POM), dc);
        this.sort(this.dependenciesMap.get((Object)ReferenceTag.PROJECTS).get((Object)Dependency.Type.JAR), dc);
        System.out.println("end sort");
    }

    private void sort(List<Dependency> list, DependencyComparator dc) throws MojoExecutionException {
        boolean ok = false;
        ArrayList<Dependency> res = new ArrayList<Dependency>();
        if (list.size() > 0) {
            while (!ok) {
                res = new ArrayList();
                res.add(list.remove(0));
                for (Dependency d2 : list) {
                    int position = res.size();
                    System.out.println("\n\nrestart");
                    System.out.println("begin Ordered list: \n" + res);
                    for (Dependency d1 : res) {
                        if (dc.d2IsInDependenciesOfd1(d1, d2) && dc.d2IsInDependenciesOfd1(d2, d1)) {
                            throw new MojoExecutionException("Error: Cyclic dependency betwwen  => " + d1 + " and " + d2);
                        }
                        if (dc.d2IsInDependenciesOfd1(d2, d1)) {
                            position = res.indexOf(d1) + 1;
                            continue;
                        }
                        if (!dc.d2IsInDependenciesOfd1(d1, d2) || position <= res.indexOf(d1)) continue;
                        position = res.indexOf(d1);
                    }
                    if (position == -1) {
                        position = 0;
                    }
                    res.add(position, d2);
                    System.out.println("end Ordered list: \n" + res);
                }
                ok = true;
                int pos = -1;
                Dependency badD = null;
                block3: for (int i = 0; i < res.size() - 1; ++i) {
                    for (int j = i + 1; j < res.size(); ++j) {
                        System.out.println(res.get(i) + " doit etre compiler avant " + res.get(j));
                        if (!dc.d2IsInDependenciesOfd1((Dependency)res.get(i), (Dependency)res.get(j))) continue;
                        System.out.println("=> FAUX, on recommence!!!!!");
                        ok = false;
                        badD = (Dependency)res.get(j);
                        pos = i;
                        break block3;
                    }
                }
                if (pos != -1) {
                    res.remove(badD);
                    res.add(pos, badD);
                }
                list.clear();
                list.addAll(res);
            }
        }
        System.out.println("\n\nfinal Ordered list: \n" + list);
        System.out.println("end");
    }

    public void setTestSkip(boolean testSkip) {
        this.testSkip = testSkip;
    }

    private void setDependencyInMap(ReferenceTag tag, Dependency.Type type, Dependency d) {
        List<Dependency> depList;
        Map<Dependency.Type, List<Dependency>> typeDepList = this.dependenciesMap.get((Object)tag);
        if (typeDepList == null) {
            typeDepList = new HashMap<Dependency.Type, List<Dependency>>();
        }
        if ((depList = typeDepList.get((Object)type)) == null) {
            depList = new ArrayList<Dependency>();
        }
        depList.add(d);
        typeDepList.put(type, depList);
        this.dependenciesMap.put(tag, typeDepList);
    }

    private Dependency.Type findType(Dependency d) {
        if (d.getProjectModel().getPackaging().equals("pom")) {
            return Dependency.Type.POM;
        }
        if (d.getProjectModel().getPackaging().equals("jar")) {
            return Dependency.Type.JAR;
        }
        if (d.getProjectModel().getPackaging().equals("maven-plugin")) {
            return Dependency.Type.JAR;
        }
        if (d.getProjectModel().getPackaging().equals("war")) {
            return Dependency.Type.JAR;
        }
        return null;
    }

    private ReferenceTag findReferenceTag(Dependency d) {
        if (d.getLocation().toString().contains("/" + ReferenceTag.BOOTSTRAP.toString() + "/")) {
            return ReferenceTag.BOOTSTRAP;
        }
        if (d.getLocation().toString().contains("/" + ReferenceTag.STABLE.toString() + "/")) {
            return ReferenceTag.STABLE;
        }
        if (d.getLocation().toString().contains("/" + ReferenceTag.COOKING.toString() + "/")) {
            return ReferenceTag.COOKING;
        }
        if (d.getLocation().toString().contains("/" + ReferenceTag.PROD.toString() + "/")) {
            return ReferenceTag.PROD;
        }
        if (d.getLocation().toString().contains("/" + ReferenceTag.EXPERIMENTAL.toString() + "/")) {
            return ReferenceTag.EXPERIMENTAL;
        }
        if (d.getLocation().toString().contains("/" + ReferenceTag.COMMONS.toString() + "/")) {
            return ReferenceTag.COMMONS;
        }
        if (d.getLocation().toString().contains("/" + ReferenceTag.PROJECTS.toString() + "/")) {
            return ReferenceTag.PROJECTS;
        }
        return null;
    }

    private void changeVersion(Dependency dependence) throws MojoExecutionException {
        Model m = dependence.getProjectModel().getModel();
        m.setVersion(this.version);
        if (m.getParent() != null && m.getParent().getVersion() != null && m.getParent().getVersion().contains("SNAPSHOT")) {
            m.getParent().setVersion(this.version);
        }
        if (m.getParent() != null && m.getParent().getRelativePath() != null) {
            m.getParent().setRelativePath(m.getParent().getRelativePath().replace("pom.xml", "pom-" + this.version + ".xml"));
        }
        if (m.getProperties() != null) {
            HashMap<Object, Object> temp = new HashMap<Object, Object>(m.getProperties());
            for (Map.Entry entry : temp.entrySet()) {
                String version;
                if (!(entry.getValue() instanceof String) || (version = (String)entry.getValue()) == null || !version.contains("SNAPSHOT") || entry.getKey().equals("frascati.version") || entry.getKey().equals("i3s.version")) continue;
                m.getProperties().put(entry.getKey(), this.version);
            }
        }
        for (org.apache.maven.model.Dependency d : m.getDependencies()) {
            if (d.getVersion() == null || !d.getVersion().contains("SNAPSHOT") || this.tree.getDependenciesToExclude().contains(d)) continue;
            d.setVersion(this.version);
        }
        if (m.getBuild() != null) {
            for (Plugin p : m.getBuild().getPlugins()) {
                Object obj;
                if (p.getVersion() != null && p.getVersion().contains("SNAPSHOT")) {
                    p.setVersion(this.version);
                }
                if ((obj = p.getConfiguration()) == null) continue;
                if (obj instanceof Xpp3Dom) {
                    Xpp3Dom dom = (Xpp3Dom)obj;
                    for (Xpp3Dom c : dom.getChildren()) {
                        Xpp3Dom v;
                        if (c.getName().equals("episodes")) {
                            for (Xpp3Dom ep : c.getChildren()) {
                                if (!ep.getName().equals("episode") || (v = ep.getChild("version")) == null || !v.getValue().contains("SNAPSHOT")) continue;
                                v.setValue(this.version);
                            }
                        }
                        if (!c.getName().equals("plugins")) continue;
                        for (Xpp3Dom pl : c.getChildren()) {
                            if (!pl.getName().equals("plugin") || (v = pl.getChild("version")) == null || !v.getValue().contains("SNAPSHOT")) continue;
                            v.setValue(this.version);
                        }
                    }
                    continue;
                }
                throw new MojoExecutionException("Impossible to analyse configuration content of plugin!!!");
            }
        }
    }

    public void installFile(Dependency dependence) throws MojoExecutionException {
        String javaPath = System.getenv("JAVA_HOME");
        if (javaPath == null) {
            throw new MojoExecutionException("JAVA_HOME must be setted!!!");
        }
        String mavenPath = System.getenv("MAVEN_HOME");
        if (mavenPath == null) {
            throw new MojoExecutionException("MAVEN_HOME is not setted!!!");
        }
        try {
            if (!new File(URI.create(dependence.getLocation().toString().replace("pom.xml", "done"))).exists()) {
                String script = null;
                if (OSValidator.isWindows()) {
                    script = new String(System.getenv("MAVEN_HOME") + "/bin/mvn.bat");
                } else if (OSValidator.isMac() || OSValidator.isUnix()) {
                    script = new String(System.getenv("MAVEN_HOME") + "/bin/mvn");
                } else {
                    throw new MojoExecutionException("Sorry, but this OS is not supported. EasiestDEMO SDK run on Windows, Mac or Unix system");
                }
                ProcessBuilder pb = new ProcessBuilder(script);
                pb.directory(new File(URI.create(dependence.getLocation().toString().replace("pom.xml", ""))));
                String pomFile = "pom-" + this.version + ".xml";
                if (this.testSkip && !dependence.isTestIsRequired()) {
                    if (!this.javadoc) {
                        System.out.println("start command: " + script + " install" + " source:jar" + " deploy" + " -f=" + pomFile + " -e" + " -Dmaven.test.skip");
                        pb.command(script, "install", "source:jar", "deploy", "-f=" + pomFile, "-e", "-Dmaven.test.skip");
                    } else {
                        System.out.println("start command: " + script + " install" + " source:jar" + " javadoc:javadoc" + " deploy" + " -f=" + pomFile + " -e" + " -Dmaven.test.skip");
                        pb.command(script, "install", "source:jar", "javadoc:javadoc", "deploy", "-f=" + pomFile, "-e", "-Dmaven.test.skip");
                    }
                } else if (!this.javadoc) {
                    System.out.println("start command: " + script + " install" + " source:jar" + " deploy" + " -f=" + pomFile + " -e");
                    pb.command(script, "install", "source:jar", "deploy", "-f=" + pomFile, "-e");
                } else {
                    System.out.println("start command: " + script + " install" + " source:jar" + " javadoc:javadoc" + " deploy" + " -f=" + pomFile + " -e");
                    pb.command(script, "install", "source:jar", "javadoc:javadoc", "deploy", "-f=" + pomFile, "-e");
                }
                pb.redirectErrorStream(true);
                Process p = pb.start();
                this.writeInputStream(p.getInputStream());
                this.writeInputStream(p.getErrorStream());
                p.waitFor();
                if (p.exitValue() != 0) {
                    throw new MojoExecutionException("Impossible to install: " + pomFile);
                }
                new File(URI.create(dependence.getLocation().toString().replace("pom.xml", "done"))).createNewFile();
            } else {
                System.out.println("Release of this artifact already done: " + dependence.getArtifactId());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void writeInputStream(InputStream ips) throws IOException {
        String ligne;
        InputStreamReader ipsr = new InputStreamReader(ips);
        BufferedReader br = new BufferedReader(ipsr);
        while ((ligne = br.readLine()) != null) {
            System.out.println(ligne);
            System.out.flush();
        }
        br.close();
    }

    public void setBaseDir(URI uri) {
        this.tree.setBaseDir(uri);
    }

    public static enum ReferenceTag {
        BOOTSTRAP("bootstrap"),
        STABLE("stable"),
        PROD("prod"),
        COOKING("cooking"),
        EXPERIMENTAL("experimental"),
        COMMONS("commons"),
        PROJECTS("projects");

        private String val;

        private ReferenceTag(String val) {
            this.val = val;
        }

        public String toString() {
            return this.val;
        }
    }
}

