/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.extended.service.autoflush.impl;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AbstractServiceImpl;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.extended.service.autoflush.api.AutoFlushMessageService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class AutoFlushMessageServiceImpl
extends AbstractServiceImpl
implements AutoFlushMessageService {
    private Logger log = Logger.getLogger(AutoFlushMessageServiceImpl.class.getName());
    private final Map<QName, List<Map<InternalMessage, ExternalContext>>> messageRegistry = Collections.synchronizedMap(new HashMap());

    public AutoFlushMessageServiceImpl(Engine engine) {
        super(engine);
    }

    public void run() {
        try {
            this.flushMessagesInRegistry();
            Thread.sleep(this.getRefreshFrequency());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.severe("Error in auto trash service: " + e.getMessage());
        }
    }

    @Override
    public void flushMessagesInRegistry() throws CoreException {
        this.log.finest("flush stored messages");
        ArrayList<Map<InternalMessage, ExternalContext>> allMsgs = new ArrayList<Map<InternalMessage, ExternalContext>>();
        for (List<Map<InternalMessage, ExternalContext>> list : this.messageRegistry.values()) {
            allMsgs.addAll(list);
        }
        this.messageRegistry.clear();
        for (Map map : allMsgs) {
            for (Map.Entry entry : map.entrySet()) {
                Engine engine = this.getEngine();
                InternalMessage im = (InternalMessage)entry.getKey();
                ExternalContext ec = (ExternalContext)entry.getValue();
                engine.accept(im, ec);
            }
        }
    }

    @Override
    public void addMessagesInRegistry(InternalMessage internalMessage, ExternalContext context) {
        List<Map<InternalMessage, ExternalContext>> msgs = this.messageRegistry.get(internalMessage.getQName());
        if (msgs == null) {
            msgs = new ArrayList<Map<InternalMessage, ExternalContext>>();
        }
        HashMap<InternalMessage, ExternalContext> map = new HashMap<InternalMessage, ExternalContext>();
        map.put(internalMessage, context);
        msgs.add(map);
        this.messageRegistry.put(internalMessage.getQName(), msgs);
    }
}

