/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.impl;

import java.util.Map;
import java.util.logging.Logger;

import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api.DebugBehaviour;
import com.ebmwebsourcing.easyviper.core.service.extended.behaviour.api.AbstractExtendedBehaviourImpl;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component(provides = @Interface(name = "service", signature = DebugBehaviour.class))
public class DebugBehaviourImpl extends AbstractExtendedBehaviourImpl implements
		DebugBehaviour {

	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(DebugBehaviourImpl.class
			.getName());

	@Requires(name = "node", contingency = Contingency.OPTIONAL)
	protected Node node;
	
	private Boolean activate = false;

	public DebugBehaviourImpl() {
		
	}


	public Map<String, Object> getInitializationContext()
	throws CoreException {
		super.getInitializationContext();
		context.put("activate", this.activate);
		return context;
	}

	public void setInitializationContext(final Map<String, Object> context)
	throws CoreException {
		this.context.put("activate", context.get("activate"));
		this.activate = (Boolean) context.get("activate");
	}


	@Override
	public String toString() {
		return "BreakpointActivity";
	}

	@Override
	public Node getNode() {
		return this.node;
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}


	public boolean isActivate() {
		return this.activate;
	}


	public void setActivate(boolean activate) {
		this.activate = activate;
	}


	@Override
	protected void executeOnEnded() throws CoreException {
		
	}


	@Override
	protected void executeOnInactive() throws CoreException {
		this.log.finest("start debug behaviour on node: "
				+ this.node.getName());
		this.state = State.ACTIVITY_STARTED;

		this.log.finest("is debug mode? "
				+ this.activate);
	}


	@Override
	protected void executeOnStarted() throws CoreException {
		
	}

}