/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.impl;

import java.util.Map;
import java.util.logging.Logger;

import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.StringExpression;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api.EchoBehaviour;
import com.ebmwebsourcing.easyviper.core.service.extended.behaviour.api.AbstractExtendedBehaviourImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component(provides = @Interface(name = "service", signature = EchoBehaviour.class))
public class EchoBehaviourImpl extends AbstractExtendedBehaviourImpl implements EchoBehaviour {



	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(EchoBehaviourImpl.class.getName());

	@Requires(name = "node", contingency = Contingency.OPTIONAL)
	protected Node node;

	private StringExpression<?> message;

	public EchoBehaviourImpl() {

	}


	public Map<String, Object> getInitializationContext()
	throws CoreException {
		super.getInitializationContext();
		context.put("message", this.message);
		return context;
	}

	public void setInitializationContext(final Map<String, Object> context)
	throws CoreException {
		this.context.put("message", context.get("message"));
		this.message = (StringExpression<?>) context.get("message");
	}

	@Override
	public String toString() {
		return "EchoActivity";
	}

	public StringExpression<?> getMessage() {
		return this.message;
	}

	public void setMessage(final StringExpression<?> message) {
		this.message = message;
	}

	@Override
	public Node getNode() {
		return this.node;
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}


	@Override
	protected void executeOnEnded() throws CoreException {
	}


	@Override
	protected void executeOnInactive() throws CoreException {
		this.log.finest("start echo behaviour on node: " + this.node.getName());
		this.state = State.ACTIVITY_STARTED;
		this.log.finest("execute echo behaviour: " + this.message);
		if(this.message != null) {
			System.out.println(this.message.evaluate(this.node.getExecution().getParentScope()));
		}
	}


	@Override
	protected void executeOnStarted() throws CoreException {
	}

}