/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.impl;

import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api.BreakpointBehaviour;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api.DebugBehaviour;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.util.DebugUtil;
import com.ebmwebsourcing.easyviper.core.service.extended.behaviour.api.AbstractExtendedBehaviourImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value=BreakpointBehaviour.class,names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class BreakpointBehaviourImpl extends AbstractExtendedBehaviourImpl implements
BreakpointBehaviour {

	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(BreakpointBehaviourImpl.class
			.getName());

	@Reference(name="node",required=false)
	protected Node node;

	public BreakpointBehaviourImpl() {

	}


	@Override
	public String toString() {
		return "BreakpointActivity";
	}

	@Override
	public Node getNode() {
		return this.node;
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}


	@Override
	protected void executeOnEnded() throws CoreException {
		
	}


	@Override
	protected void executeOnInactive() throws CoreException {
		this.log.finest("start breakpoint behaviour on node: "
				+ this.node.getName());
		this.state = State.ACTIVITY_STARTED;

		DebugBehaviour debug = DebugUtil.findDebugBehaviour(this.getNode().getExecution().getParentScope().getProcess());
		if (debug != null) {
			this.log.finest("is debug mode? "
					+ debug.isActivate());
		} else {
			this.log.finest("is debug mode? false - no debug behaviour found");
		}
		if (debug != null && debug.isActivate()) {
			this.getNode().getExecution().setState(
					Execution.State.SUSPENDED);
			this.log.finest("breakpoint behaviour: suspend the execution "
					+ this.getNode().getExecution().getName() + " => "
					+ this.getNode().getExecution().getState());
			this.getNode().selectDefaultNextTarget();
		}
	}


	@Override
	protected void executeOnStarted() throws CoreException {
		
	}




}