/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.command.extended.service.command.impl;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.administration.ActivityIdType;
import com.ebmwebsourcing.easyviper.administration.AddNodeDataModelType;
import com.ebmwebsourcing.easyviper.administration.EndpointType;
import com.ebmwebsourcing.easyviper.administration.InsertAs;
import com.ebmwebsourcing.easyviper.administration.StartProcessInstance;
import com.ebmwebsourcing.easyviper.administration.StartProcessInstanceResponse;
import com.ebmwebsourcing.easyviper.administration.StopProcessInstance;
import com.ebmwebsourcing.easyviper.administration.StopProcessInstanceResponse;
import com.ebmwebsourcing.easyviper.administration.StoreProcessDefinition;
import com.ebmwebsourcing.easyviper.administration.StoreProcessDefinitionResponse;
import com.ebmwebsourcing.easyviper.administration.UnStoreProcessDefinition;
import com.ebmwebsourcing.easyviper.administration.UnStoreProcessDefinitionResponse;
import com.ebmwebsourcing.easyviper.command.AddNodeFault;
import com.ebmwebsourcing.easyviper.command.ReplaceEndpointFault;
import com.ebmwebsourcing.easyviper.command.StartProcessInstanceFault;
import com.ebmwebsourcing.easyviper.command.StopProcessInstanceFault;
import com.ebmwebsourcing.easyviper.command.StoreProcessDefinitionFault;
import com.ebmwebsourcing.easyviper.command.UnStoreProcessDefinitionFault;
import com.ebmwebsourcing.easyviper.command.extended.service.command.api.ExtendedServiceCommand;
import com.ebmwebsourcing.easyviper.command.extended.service.command.util.NodeWrapperUtil;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.SenderBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AbstractServiceImpl;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessContextDefinitionImpl;
import easyviper.petalslink.com.datamodel._1.NodeType;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class ExtendedServiceCommandImpl
extends AbstractServiceImpl
implements ExtendedServiceCommand {
    private Logger log = Logger.getLogger(ExtendedServiceCommandImpl.class.getName());

    public ExtendedServiceCommandImpl(Engine engine) {
        super(engine);
    }

    public void run() {
        try {
            Thread.sleep(this.getRefreshFrequency());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.log.severe("Error in extended command service: " + e.getMessage());
        }
    }

    @Override
    public StoreProcessDefinitionResponse storeProcessDefinition(StoreProcessDefinition bpelUrl) throws StoreProcessDefinitionFault {
        String url = bpelUrl.getBPELUrlDataModel();
        StoreProcessDefinitionResponse res = new StoreProcessDefinitionResponse();
        String resString = "";
        try {
            URL bpelURL = new URL(url);
            ProcessDefinition def = this.getEngine().getCore().getModel().getRegistry().storeProcessDefinition(bpelURL.toURI(), (ProcessContextDefinition)new ProcessContextDefinitionImpl(1));
            List keys = this.getEngine().getCore().getModel().getRegistry().createKeys(def);
            if (keys.size() > 0) {
                resString = ((ProcessKey)keys.get(0)).getService().toString() + "::" + ((ProcessKey)keys.get(0)).getEndpoint();
            }
        }
        catch (MalformedURLException e) {
            resString = "The URL given " + url + " is not a valid URL: " + e.getLocalizedMessage();
            this.log.severe(e.getMessage());
            com.ebmwebsourcing.easyviper.administration.StoreProcessDefinitionFault fault = new com.ebmwebsourcing.easyviper.administration.StoreProcessDefinitionFault();
            fault.setStoreProcessDefinitionFault(resString);
            StoreProcessDefinitionFault ee = new StoreProcessDefinitionFault(e.getLocalizedMessage(), fault);
            throw ee;
        }
        catch (CoreException e) {
            resString = "Problem with BPEL compilation: " + e.getLocalizedMessage();
            this.log.severe(e.getMessage());
            com.ebmwebsourcing.easyviper.administration.StoreProcessDefinitionFault fault = new com.ebmwebsourcing.easyviper.administration.StoreProcessDefinitionFault();
            fault.setStoreProcessDefinitionFault(resString);
            StoreProcessDefinitionFault ee = new StoreProcessDefinitionFault(e.getLocalizedMessage(), fault);
            throw ee;
        }
        catch (URISyntaxException e) {
            resString = "The URL given " + url + " is not a valid URL: " + e.getLocalizedMessage();
            this.log.severe(e.getMessage());
            com.ebmwebsourcing.easyviper.administration.StoreProcessDefinitionFault fault = new com.ebmwebsourcing.easyviper.administration.StoreProcessDefinitionFault();
            fault.setStoreProcessDefinitionFault(resString);
            StoreProcessDefinitionFault ee = new StoreProcessDefinitionFault(e.getLocalizedMessage(), fault);
            throw ee;
        }
        res.setAcknowledgementDataModel(resString);
        return res;
    }

    @Override
    public UnStoreProcessDefinitionResponse unStoreProcessDefinition(UnStoreProcessDefinition processDM) throws UnStoreProcessDefinitionFault {
        UnStoreProcessDefinitionResponse res = new UnStoreProcessDefinitionResponse();
        try {
            URI uri = new URL(processDM.getUnStoreProcessDefinitionInputURI()).toURI();
            boolean forceUninstall = processDM.isUnStoreProcessDefinitionInputForce();
            this.getEngine().getCore().getModel().getRegistry().unStoreProcessDefinition(uri, forceUninstall);
        }
        catch (MalformedURLException e) {
            com.ebmwebsourcing.easyviper.administration.UnStoreProcessDefinitionFault fault = new com.ebmwebsourcing.easyviper.administration.UnStoreProcessDefinitionFault();
            fault.setUnStoreProcessDefinitionFault("Failed to unstore the process " + processDM.getUnStoreProcessDefinitionInputURI() + " : " + e.getLocalizedMessage());
            UnStoreProcessDefinitionFault faultException = new UnStoreProcessDefinitionFault("MalformedURLException", fault);
            faultException.setStackTrace(e.getStackTrace());
            throw faultException;
        }
        catch (URISyntaxException e) {
            com.ebmwebsourcing.easyviper.administration.UnStoreProcessDefinitionFault fault = new com.ebmwebsourcing.easyviper.administration.UnStoreProcessDefinitionFault();
            fault.setUnStoreProcessDefinitionFault("Failed to unstore the process " + processDM.getUnStoreProcessDefinitionInputURI() + " : " + e.getLocalizedMessage());
            UnStoreProcessDefinitionFault faultException = new UnStoreProcessDefinitionFault(e.getLocalizedMessage(), fault);
            faultException.setStackTrace(e.getStackTrace());
            throw faultException;
        }
        catch (CoreException e) {
            com.ebmwebsourcing.easyviper.administration.UnStoreProcessDefinitionFault fault = new com.ebmwebsourcing.easyviper.administration.UnStoreProcessDefinitionFault();
            fault.setUnStoreProcessDefinitionFault("Failed to unstore the process " + processDM.getUnStoreProcessDefinitionInputURI() + " : " + e.getLocalizedMessage());
            UnStoreProcessDefinitionFault faultException = new UnStoreProcessDefinitionFault(e.getLocalizedMessage(), fault);
            faultException.setStackTrace(e.getStackTrace());
            throw faultException;
        }
        return res;
    }

    @Override
    public StopProcessInstanceResponse stopProcessInstance(StopProcessInstance processInstanceName) throws StopProcessInstanceFault {
        this.log.finest("stop process : " + processInstanceName);
        try {
            StopProcessInstanceResponse ack = new StopProcessInstanceResponse();
            Process proc = this.getEngine().findProcessFromName(processInstanceName.getStopProcessInstanceNameDataModel());
            if (proc != null) {
                try {
                    for (Scope s : proc.getAllScopes()) {
                        Component execComp = SCAHelper.getSCAHelper().getFirstComponentByName(s.getComponent(), "exec_in_" + s.getName());
                        System.out.println("..." + execComp);
                        if (execComp == null || !SCAHelper.getSCAHelper().isStarted(execComp)) continue;
                        System.out.println("Execution to be stopped ... " + SCAHelper.getSCAHelper().getName(execComp));
                        SCAHelper.getSCAHelper().stopComponent(execComp);
                    }
                    Component main = SCAHelper.getSCAHelper().getFirstComponentByName(proc.getComponent(), "mainExec");
                    try {
                        ((Execution)main.getFcInterface("service")).setState(Execution.State.SUSPENDED);
                    }
                    catch (NoSuchInterfaceException e) {
                        e.printStackTrace();
                    }
                    SCAHelper.getSCAHelper().stopComponent(proc.getComponent());
                }
                catch (SCAException e) {
                    e.printStackTrace();
                }
                return ack;
            }
            throw new CoreException("Process not found");
        }
        catch (CoreException e) {
            this.log.severe("Failed to stop execution of process " + processInstanceName + ".");
            com.ebmwebsourcing.easyviper.administration.StopProcessInstanceFault fault = new com.ebmwebsourcing.easyviper.administration.StopProcessInstanceFault();
            fault.setStopProcessInstanceFault("Failed to stop execution of process " + processInstanceName + ".");
            StopProcessInstanceFault stopException = new StopProcessInstanceFault(e.getLocalizedMessage(), fault);
            throw stopException;
        }
    }

    @Override
    public StartProcessInstanceResponse startProcessInstance(StartProcessInstance processInstanceName) throws StartProcessInstanceFault {
        this.log.finest("restart process : " + processInstanceName.getStartProcessInstanceNameDataModel());
        StartProcessInstanceResponse ack = new StartProcessInstanceResponse();
        try {
            SCAHelper.getSCAHelper().startComponent(SCAHelper.getSCAHelper().getFirstComponentByName(this.getEngine().getComponent(), processInstanceName.getStartProcessInstanceNameDataModel()));
            Process proc = this.getEngine().findProcessFromName(processInstanceName.getStartProcessInstanceNameDataModel());
            if (proc != null) {
                proc.getParentExecution().startSCAComponent();
                for (Scope s : proc.getAllScopes()) {
                    Component execComp = SCAHelper.getSCAHelper().getFirstComponentByName(s.getComponent(), "exec_in_" + s.getName());
                    SCAHelper.getSCAHelper().startComponent(execComp);
                }
                Component main = SCAHelper.getSCAHelper().getFirstComponentByName(proc.getComponent(), "mainExec");
                try {
                    ((Execution)main.getFcInterface("service")).setState(Execution.State.ACTIVE);
                    ((Execution)main.getFcInterface("service")).run();
                }
                catch (NoSuchInterfaceException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SCAException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return ack;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void replaceEndpoint(EndpointType endpoint, ActivityIdType activityId) throws ReplaceEndpointFault {
        System.out.println("Replace Endpoint : 0");
        Component procComp = null;
        try {
            procComp = SCAHelper.getSCAHelper().getFirstComponentByName(this.getEngine().getComponent(), activityId.getProcessInstanceName());
            SCAHelper.getSCAHelper().startComponent(procComp);
            Process proc = this.getEngine().findProcessFromName(activityId.getProcessInstanceName());
            Behaviour behaviour = null;
            if (proc == null) {
                behaviour = null;
                com.ebmwebsourcing.easyviper.administration.ReplaceEndpointFault fault = new com.ebmwebsourcing.easyviper.administration.ReplaceEndpointFault();
                fault.setReplaceEndpointFault("Failed to replace endpoint ... activity not yet started.");
                ReplaceEndpointFault replaceException = new ReplaceEndpointFault("ReplaceEndpoint exception", fault);
                throw replaceException;
            }
            System.out.println("Replace Endpoint : 1");
            System.out.println("Replace Endpoint : 2");
            behaviour = proc.findBehaviour(activityId.getActivityName());
            if (behaviour == null) {
                behaviour = null;
                com.ebmwebsourcing.easyviper.administration.ReplaceEndpointFault fault = new com.ebmwebsourcing.easyviper.administration.ReplaceEndpointFault();
                fault.setReplaceEndpointFault("Not an invoke activity");
                ReplaceEndpointFault replaceException = new ReplaceEndpointFault("ReplaceEndpoint exception", fault);
                throw replaceException;
            }
            System.out.println("Replace Endpoint : 3");
            if (behaviour instanceof SenderBehaviour) {
                System.out.println("Replace Endpoint : 4");
                SenderBehaviour senderBehaviour = (SenderBehaviour)behaviour;
                Endpoint edp = proc.findEndpoint(SCAHelper.getSCAHelper().getPropertyValue(senderBehaviour.getComponent(), "providerEndpointKey", Object.class));
                if (endpoint.getEndpointName() != null && !endpoint.getEndpointName().contains("?")) {
                    edp.setEndpointName(endpoint.getEndpointName());
                }
                if (endpoint.getService() != null && !endpoint.getService().getLocalPart().contains("?")) {
                    edp.setServiceName(endpoint.getService());
                }
                if (endpoint.getInterface() != null && !endpoint.getInterface().getLocalPart().contains("?")) {
                    edp.setInterfaceName(endpoint.getInterface());
                }
                System.out.println("Replace Endpoint : 5 " + edp.getEndpointName());
            }
        }
        catch (SCAException e) {
            try {
                this.log.severe(e.getMessage());
                com.ebmwebsourcing.easyviper.administration.ReplaceEndpointFault fault = new com.ebmwebsourcing.easyviper.administration.ReplaceEndpointFault();
                fault.setReplaceEndpointFault("error replacing endpoint (SCA exception)");
                ReplaceEndpointFault replaceException = new ReplaceEndpointFault(e.getLocalizedMessage(), fault);
                throw replaceException;
                catch (CoreException e2) {
                    this.log.severe(e2.getMessage());
                    fault = new com.ebmwebsourcing.easyviper.administration.ReplaceEndpointFault();
                    fault.setReplaceEndpointFault("error replacing endpoint (Core exception)");
                    replaceException = new ReplaceEndpointFault(e2.getLocalizedMessage(), fault);
                    throw replaceException;
                }
            }
            catch (Throwable throwable) {
                try {
                    SCAHelper.getSCAHelper().startComponent(procComp);
                    throw throwable;
                }
                catch (SCAException e3) {
                    e3.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            SCAHelper.getSCAHelper().startComponent(procComp);
            return;
        }
        catch (SCAException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void addNode(AddNodeDataModelType addNodeDataModel) throws AddNodeFault {
        try {
            StartProcessInstance processInstanceName = new StartProcessInstance();
            processInstanceName.setStartProcessInstanceNameDataModel(addNodeDataModel.getNodeToAdd().getParentScope().getProcess().getProcessName());
            this.startProcessInstance(processInstanceName);
            String nodeBeforeName = addNodeDataModel.getNodeBeforeName();
            NodeType node = addNodeDataModel.getNodeToAdd();
            Process process = this.getEngine().findProcessFromName(node.getParentScope().getProcess().getProcessName());
            Node newnode = NodeWrapperUtil.wrapModelToEasyVIPERNode(node, process);
            Node nodeBefore = process.findBehaviour(nodeBeforeName).getNode();
            Component fractalNode = nodeBefore.getComponent();
            Node nodeBefore2 = (Node)fractalNode.getFcInterface("service");
            if (addNodeDataModel.getInsertAs().equals((Object)InsertAs.BROTHER)) {
                Node after = process.unlinkBrotherNodes(nodeBefore2, null);
                process.linkedBrotherNodes(nodeBefore2, newnode);
                process.linkedBrotherNodes(newnode, after);
            } else if (addNodeDataModel.getInsertAs().equals((Object)InsertAs.CHILD)) {
                process.linkedChildNodeToParent(nodeBefore, newnode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AddNodeFault ee = new AddNodeFault(e.getLocalizedMessage());
            throw ee;
        }
        finally {
            StopProcessInstance processInstanceName = new StopProcessInstance();
            processInstanceName.setStopProcessInstanceNameDataModel(addNodeDataModel.getNodeToAdd().getParentScope().getProcess().getProcessName());
        }
    }
}

