/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.command.extended.service.command.util;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.SenderBehaviour;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageAdapter;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.SenderBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.soa.EndpointImpl;
import easyviper.petalslink.com.datamodel._1.AbstractBehaviourType;
import easyviper.petalslink.com.datamodel._1.NodeType;
import easyviper.petalslink.com.datamodel._1.SenderBehaviourType;
import easyviper.petalslink.com.datamodel._1.SequenceBehaviourType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class NodeWrapperUtil {
    public static Node wrapModelToEasyVIPERNode(NodeType nodeDataModel, Process process) throws CoreException {
        Node res = null;
        try {
            String nodeName = nodeDataModel.getBehaviour().getName();
            AbstractBehaviourType behaviour = nodeDataModel.getBehaviour();
            if (behaviour instanceof SenderBehaviourType) {
                Object key = ((SenderBehaviourType)behaviour).getProviderEndpointKey();
                EndpointImpl endpoint = new EndpointImpl();
                endpoint.setEndpointName(((SenderBehaviourType)behaviour).getEndpoint().getEndpoint());
                endpoint.setInterfaceName(((SenderBehaviourType)behaviour).getEndpoint().getInterface());
                endpoint.setServiceName(((SenderBehaviourType)behaviour).getEndpoint().getService());
                endpoint.setInvokedOperation(((SenderBehaviourType)behaviour).getOperationName());
                process.getEndpoints().put(key, endpoint);
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("kind", SenderBehaviour.Kind.valueOf((String)((SenderBehaviourType)behaviour).getKind().toString()));
                context.put("inputVariableName", ((SenderBehaviourType)behaviour).getInputVariable());
                context.put("outputVariableName", ((SenderBehaviourType)behaviour).getOutputVariable());
                List senders = process.findBehaviours(SenderBehaviour.class);
                MessageAdapter ma = null;
                if (senders != null && senders.size() > 0) {
                    ma = (MessageAdapter)SCAHelper.getSCAHelper().getPropertyValue(((SenderBehaviour)senders.get(0)).getComponent(), "messageAdapter", MessageAdapter.class);
                }
                res = process.createNode(nodeName, SenderBehaviourImpl.class, context);
            } else if (behaviour instanceof SequenceBehaviourType) {
                SequenceBehaviourType sb = (SequenceBehaviourType)behaviour;
                res = CreationPatternFactory.getInstance().createSequencePattern(sb.getName(), NodeWrapperUtil.retrieveChildNodes(sb.getNode(), process), (Scope)process);
            }
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    private static List<Node> retrieveChildNodes(NodeType node, Process process) throws CoreException {
        ArrayList<Node> res = new ArrayList<Node>();
        List<NodeType> list = node.getChildNodes().getNodes();
        for (NodeType element : list) {
            Node temp = NodeWrapperUtil.wrapModelToEasyVIPERNode(element, process);
            res.add(temp);
        }
        return res;
    }
}

