/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.extended.service.notification.impl;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.WaitBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AbstractServiceImpl;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.soa.Partner;
import com.ebmwebsourcing.easyviper.core.impl.engine.ScopeImpl;
import com.ebmwebsourcing.easyviper.extended.service.notification.api.ExtendedServiceNotification;
import com.ebmwebsourcing.easyviper.extended.service.notification.impl.util.NotifMessageContentAnalyzer;
import com.ebmwebsourcing.easyviper.extended.service.notification.impl.util.TopicSetManager;
import com.ebmwebsourcing.easyviper.intent._abstract.notify.api.NotifyIntentHandler;
import com.ebmwebsourcing.wsaddressing10.api.element.ReferenceParameters;
import com.ebmwebsourcing.wsaddressing10.api.type.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.implementor.WsrfbfModelFactory;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.WsrfbfModelFactoryImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Renew;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.RenewResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Unsubscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.implementor.WsnbModelFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.implementor.WsrfrModelFactory;
import com.ebmwebsourcing.wsstar.resource.datatypes.impl.impl.WsrfrModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.implementor.WsrfrlModelFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.impl.impl.WsrfrlModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.implementor.WsrfrpModelFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.impl.WsrfrpModelFactoryImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.WstopConstants;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.implementor.WstopModelFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopException;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.TopicTypeImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.WstopModelFactoryImpl;
import com.ebmwebsourcing.wsstar.wsnb.services.INotificationProducer;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.NotificationProducerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.SubscriptionManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.TopicsManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.WstConstants;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import easybox.org.oasis_open.docs.wsn.t_1.EJaxbTopicType;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.frascati.tinfi.TinfiDomain;
import org.ow2.frascati.tinfi.api.IntentHandler;
import org.ow2.frascati.tinfi.api.control.SCAIntentController;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExtendedServiceNotificationImpl
extends AbstractServiceImpl
implements ExtendedServiceNotification {
    private Logger log = Logger.getLogger(ExtendedServiceNotificationImpl.class.getName());
    private SubscriptionManagerEngine subscriptionManager = null;
    private INotificationProducer producer = null;
    private TopicSetManager topicSetManager = null;
    private TopicsManagerEngine topicMgrEngine = null;
    public static final String EBM_RESOURCEIDS_PREFIX = "ebm";
    public static final String EBM_RESOURCEIDS_NAMESPACE_URI = "http://petals.ow2.org/ebmwebsourcing/specific/ResourceIds";
    private static final String EBM_TOPICS_EXTENSION_NAMESPACE_URI = "http://org.ow2.petals/ebmwebsourcing/specific/topicExtension";
    public static final QName SUPPORTED_QNAME_ATTR = new QName("http://org.ow2.petals/ebmwebsourcing/specific/topicExtension", "supported", "ebm");
    private Map<ProcessKey, NotifyIntentHandler> intentsByProcessDef = new HashMap<ProcessKey, NotifyIntentHandler>();
    private static Map<Partner, Map<String, ExternalContext>> context = null;
    private Map<String, ProcessKey> keysByRuuid = new HashMap<String, ProcessKey>();

    public ExtendedServiceNotificationImpl(Engine engine) throws CoreException {
        super(engine);
        try {
            this.topicSetManager = TopicSetManager.newInstance();
            this.subscriptionManager = new SubscriptionManagerEngine(this.log);
            TopicsManagerEngine topicsMgr = new TopicsManagerEngine();
            URL wsdl = this.getClass().getResource("/description/NotificationService.wsdl");
            if (wsdl != null) {
                Description desc = WSDLFactory.newInstance().newWSDLReader().read(wsdl);
                this.setDescription(desc);
            }
            this.initNotification();
        }
        catch (WsnbException e) {
            e.printStackTrace();
            throw new CoreException("Extended notification service initialization failed ... " + e.getMessage());
        }
        catch (WSDLException e) {
            e.printStackTrace();
            throw new CoreException("Extended notification service initialization failed ... " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CoreException("Extended notification service initialization failed ... " + e.getMessage());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new CoreException("Extended notification service initialization failed ... " + e.getMessage());
        }
    }

    public void run() {
        try {
            Thread.sleep(this.getRefreshFrequency());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.log.severe("Error in extended notification service: " + e.getMessage());
        }
    }

    private int weaveIntent(List<Process> involvedProcesses, String ruuid, QName topicFilter, String address) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalLifeCycleException, NoSuchInterfaceException, java.lang.InstantiationException, SCAException, CoreException {
        int numberOfIntentsWeaved = 0;
        for (Process p : involvedProcesses) {
            boolean isStarted;
            SCAIntentController ic;
            Component c;
            List behaviours;
            ProcessKey key = (ProcessKey)p.getProcessKeys().get(0);
            this.keysByRuuid.put(ruuid, key);
            if (this.intentsByProcessDef.containsKey(key)) {
                this.log.finest("INTENT FOUND ...");
                this.intentsByProcessDef.get(key).addAddress(address);
            } else {
                this.log.finest("NEW INTENT ...");
                NotifyIntentHandler h1 = null;
                if (topicFilter.toString().contains("ProcessStateChanged")) {
                    h1 = (NotifyIntentHandler)TinfiDomain.getService((String)"com.ebmwebsourcing.easyviper.intent._default.impl.DefaultNotifyIntentForProcessImplFactory", NotifyIntentHandler.class, (String)"notify");
                } else if (topicFilter.toString().contains("ActivityChanged")) {
                    h1 = (NotifyIntentHandler)TinfiDomain.getService((String)"com.ebmwebsourcing.easyviper.intent._default.impl.DefaultNotifyIntentForBehaviourImplFactory", NotifyIntentHandler.class, (String)"notify");
                } else if (topicFilter.toString().contains("WaitBehaviour")) {
                    h1 = (NotifyIntentHandler)TinfiDomain.getService((String)"com.ebmwebsourcing.easyviper.intent._default.impl.DefaultNotifyIntentForWaitBehaviourImplFactory", NotifyIntentHandler.class, (String)"notify");
                } else if (topicFilter.toString().contains("ThrowBehaviour")) {
                    h1 = (NotifyIntentHandler)TinfiDomain.getService((String)"com.ebmwebsourcing.easyviper.intent._default.impl.DefaultNotifyIntentForThrowBehaviourImplFactory", NotifyIntentHandler.class, (String)"notify");
                }
                this.log.finest("BEFORE : " + h1.getAddresses().size());
                h1.addAddress(address);
                h1.setExternalcontext(context);
                this.log.finest("AFTER : " + h1.getAddresses().size());
                this.intentsByProcessDef.put(key, h1);
            }
            if (topicFilter.toString().contains("ProcessStateChanged")) {
                Component c2 = p.getComponent();
                SCAIntentController ic2 = (SCAIntentController)c2.getFcInterface("sca-intent-controller");
                boolean isStarted2 = SCAHelper.getSCAHelper().isStarted(c2);
                if (isStarted2) {
                    SCAHelper.getSCAHelper().stopComponent(c2);
                }
                ic2.addFcIntentHandler((IntentHandler)this.intentsByProcessDef.get(key));
                numberOfIntentsWeaved = 1;
                if (!isStarted2) continue;
                SCAHelper.getSCAHelper().startComponent(c2);
                continue;
            }
            if (topicFilter.toString().contains("ActivityChanged")) {
                this.log.finest("INSTANCE : " + p.getName());
                behaviours = ScopeImpl.findBehaviours(Behaviour.class, (Component)p.getComponent(), (boolean)true);
                this.log.finest("BEHAVIOURS SIZE : " + behaviours.size());
                for (Behaviour behaviour : behaviours) {
                    ++numberOfIntentsWeaved;
                    c = SCAHelper.getSCAHelper().getComponentByInterface(p.getComponent(), (Interface)behaviour, "service");
                    if (SCAHelper.getSCAHelper().getName(c).contains("node")) continue;
                    this.log.finest("COMPONENT INTO WHICH THE INTENT IS INJECTED : " + SCAHelper.getSCAHelper().getName(c));
                    ic = (SCAIntentController)c.getFcInterface("sca-intent-controller");
                    isStarted = SCAHelper.getSCAHelper().isStarted(c);
                    if (isStarted) {
                        SCAHelper.getSCAHelper().stopComponent(c);
                    }
                    ic.addFcIntentHandler((IntentHandler)this.intentsByProcessDef.get(key));
                    if (!isStarted) continue;
                    SCAHelper.getSCAHelper().startComponent(c);
                }
                continue;
            }
            if (!topicFilter.toString().contains("WaitBehaviour")) continue;
            this.log.finest("INSTANCE : " + p.getName());
            behaviours = ScopeImpl.findBehaviours(WaitBehaviour.class, (Component)p.getComponent(), (boolean)true);
            this.log.finest("BEHAVIOURS SIZE : " + behaviours.size());
            for (WaitBehaviour behaviour : behaviours) {
                ++numberOfIntentsWeaved;
                c = SCAHelper.getSCAHelper().getComponentByInterface(p.getComponent(), (Interface)behaviour, "service");
                if (SCAHelper.getSCAHelper().getName(c).contains("node")) continue;
                this.log.finest("COMPONENT INTO WHICH THE INTENT IS INJECTED : " + SCAHelper.getSCAHelper().getName(c));
                ic = (SCAIntentController)c.getFcInterface("sca-intent-controller");
                isStarted = SCAHelper.getSCAHelper().isStarted(c);
                if (isStarted) {
                    SCAHelper.getSCAHelper().stopComponent(c);
                }
                ic.addFcIntentHandler((IntentHandler)this.intentsByProcessDef.get(key));
                if (!isStarted) continue;
                SCAHelper.getSCAHelper().startComponent(c);
            }
        }
        return numberOfIntentsWeaved;
    }

    public SubscribeResponse subscribe(Subscribe request) throws WsnbException {
        this.log.finest("Subscription requested .................................");
        try {
            SubscribeResponse response = this.producer.subscribe(request);
            ReferenceParameters ref = response.getSubscriptionReference().getReferenceParameters();
            String ruuid = Wsnb4ServUtils.getSubscriptionIdFromReferenceParams((ReferenceParametersType)ref);
            String address = request.getConsumerReference().getAddress().getValue().toString();
            ArrayList processDefinitions = new ArrayList();
            List contentList = request.getFilter().getMessageContentExpressions();
            int numberOfIntentsWeaved = 0;
            if (this.getEngine().getProcessInstanceRegistry().getProcessInstances() != null && this.getEngine().getProcessInstanceRegistry().getProcessInstances().size() > 0) {
                HashSet<Process> involvedProcesses = NotifMessageContentAnalyzer.extractInvolvedProcesses(contentList, this.getEngine());
                ArrayList<Process> involvedProcessesAsList = new ArrayList<Process>();
                for (Process p : involvedProcesses) {
                    involvedProcessesAsList.add(p);
                }
                QName topicFilter = WSNHelper.getQNameInSimpleTopicExpression((TopicExpressionType)((TopicExpressionType)request.getFilter().getTopicExpressions().get(0)));
                numberOfIntentsWeaved = this.weaveIntent(involvedProcessesAsList, ruuid, topicFilter, address);
            }
            response.getSubscriptionReference().setUserData((Object)("Number of intents weaved : " + numberOfIntentsWeaved));
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public GetCurrentMessageResponse getCurrentMessage(GetCurrentMessage request) throws WsnbException, AbsWSStarFault {
        return this.producer.getCurrentMessage(request);
    }

    public RenewResponse renew(Renew request) throws WsnbException, AbsWSStarFault {
        return this.subscriptionManager.renew(request);
    }

    public UnsubscribeResponse unsubscribe(Unsubscribe request) throws WsnbException, AbsWSStarFault {
        try {
            System.out.println("[UNSUB] Unsubscribe requested ...");
            String ruuid = null;
            org.w3c.dom.Document doc = RefinedWsnbFactory.getInstance().getWsnbWriter().writeUnsubscribeAsDOM(request);
            for (int i = 0; i < doc.getChildNodes().getLength(); ++i) {
                Node docElement = doc.getChildNodes().item(i);
                if (!docElement.getLocalName().equals("Unsubscribe")) continue;
                NodeList subDocElements = docElement.getChildNodes();
                for (int j = 0; j < subDocElements.getLength(); ++j) {
                    if (!subDocElements.item(j).getLocalName().equals("EndpointReference")) continue;
                    NodeList subSubDocElements = subDocElements.item(j).getChildNodes();
                    for (int k = 0; k < subSubDocElements.getLength(); ++k) {
                        if (!subSubDocElements.item(k).getLocalName().equals("ReferenceParameters")) continue;
                        NodeList subsubsub = subSubDocElements.item(k).getChildNodes();
                        for (int l = 0; l < subsubsub.getLength(); ++l) {
                            if (!subsubsub.item(l).getLocalName().equals("SubscriptionId")) continue;
                            ruuid = subsubsub.item(l).getFirstChild().getNodeValue();
                        }
                    }
                }
                break;
            }
            System.out.println("Map ruuid / service : " + this.keysByRuuid);
            System.out.println("ruuid : " + ruuid);
            ProcessKey processkey = this.keysByRuuid.get(ruuid);
            List instances = processkey.getService() != null && processkey.getService().getLocalPart().equalsIgnoreCase("all") ? this.getEngine().getProcessInstanceRegistry().getProcessInstances() : this.getEngine().getProcessInstanceRegistry().getProcessInstances(processkey);
            for (Process instance : instances) {
                this.log.finest("INSTANCE : " + instance.getName());
                List behaviours = ScopeImpl.findBehaviours(Behaviour.class, (Component)instance.getComponent(), (boolean)true);
                this.log.finest("BEHAVIOURS SIZE : " + behaviours.size());
                for (Behaviour behaviour : behaviours) {
                    Component c = SCAHelper.getSCAHelper().getComponentByInterface(instance.getComponent(), (Interface)behaviour, "service");
                    if (SCAHelper.getSCAHelper().getName(c).contains("node")) continue;
                    this.log.finest("COMPONENT INTO WHICH THE INTENT IS REMOVED : " + SCAHelper.getSCAHelper().getName(c));
                    SCAIntentController ic = (SCAIntentController)c.getFcInterface("sca-intent-controller");
                    boolean isStarted = SCAHelper.getSCAHelper().isStarted(c);
                    if (isStarted) {
                        SCAHelper.getSCAHelper().stopComponent(c);
                    }
                    ic.removeFcIntentHandler((IntentHandler)this.intentsByProcessDef.get(processkey));
                    if (!isStarted) continue;
                    SCAHelper.getSCAHelper().startComponent(c);
                }
            }
            this.subscriptionManager.setTargetSubscriptionResourceUuid(ruuid);
            return this.subscriptionManager.unsubscribe(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<String> getSupportedTopics() {
        return this.topicSetManager.getSupportedTopics();
    }

    public boolean match(Element message) {
        boolean res = false;
        if (message == null) {
            return false;
        }
        Description desc = (Description)this.getDescription();
        List services = desc.getServices();
        return res;
    }

    public void accept(Element message, ExternalContext context) throws CoreException {
    }

    public Map<Partner, Map<String, ExternalContext>> getContext() {
        return context;
    }

    public void setContext(Map<Partner, Map<String, ExternalContext>> context) {
        ExtendedServiceNotificationImpl.context = context;
    }

    private void initNotification() throws CoreException {
        try {
            List<String> supportedTopics = this.topicSetManager.getSupportedTopics();
            if (this.topicSetManager.getSupportedTopics() != null) {
                org.w3c.dom.Document docTopicNs = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(this.topicSetManager.getViperEvents().openStream());
                TopicNamespaceType topicNs = RefinedWstopFactory.getInstance().getWstopReader().readTopicNamespaceType(docTopicNs);
                TopicSetType topicSet = this.createTopicSetFromTopicNamespace(topicNs, supportedTopics);
                org.w3c.dom.Document topicSetDom = RefinedWstopFactory.getInstance().getWstopWriter().writeTopicSetTypeAsDOM(topicSet);
                this.topicMgrEngine = new TopicsManagerEngine();
                this.subscriptionManager = new SubscriptionManagerEngine(this.log);
                if (this.getDescription() != null) {
                    this.subscriptionManager.setSubscriptionsManagerEdp(((Endpoint)((Service)((Description)this.getDescription()).getServices().get(0)).getEndpoints().get(0)).getName());
                    this.subscriptionManager.setSubscriptionsManagerInterface(((InterfaceType)((Description)this.getDescription()).getInterfaces().get(0)).getQName());
                    this.subscriptionManager.setSubscriptionsManagerService(((Service)((Description)this.getDescription()).getServices().get(0)).getQName());
                }
                this.producer = new NotificationProducerEngine(this.log, this.topicMgrEngine, this.subscriptionManager, true, topicSet, topicNs, "wsn", null);
                assert (this.producer != null);
            }
        }
        catch (IOException e) {
            throw new CoreException((Throwable)e);
        }
        catch (WsnbException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SAXException e) {
            throw new CoreException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((Throwable)e);
        }
        catch (WstopException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public TopicSetType createTopicSetFromTopicNamespace(TopicNamespaceType topicns, List<String> topics) throws CoreException {
        TopicSetType res = null;
        TopicNamespaceType topicNS = null;
        org.w3c.dom.Document domDocument = null;
        try {
            domDocument = RefinedWstopFactory.getInstance().getWstopWriter().writeTopicNamespaceTypeAsDOM(topicns);
        }
        catch (WstopException e) {
            throw new CoreException((Throwable)e);
        }
        DOMBuilder builder = new DOMBuilder();
        Document jdomDocument = builder.build(domDocument);
        this.addSupportedTopicAttr(jdomDocument.getRootElement().getChildren(), topics);
        DOMOutputter converter = new DOMOutputter();
        try {
            domDocument = converter.output(jdomDocument);
        }
        catch (JDOMException e) {
            throw new CoreException((Throwable)e);
        }
        try {
            topicNS = RefinedWstopFactory.getInstance().getWstopReader().readTopicNamespaceType(domDocument);
        }
        catch (WstopException e) {
            throw new CoreException((Throwable)e);
        }
        res = this.createTopicSetFromSupportedTopicNamespace(topicNS);
        return res;
    }

    private void addSupportedTopicAttr(List<Element> children, List<String> topics) {
        for (Element child : children) {
            if (!child.getName().equals(WstopConstants.TOPIC_QNAME.getLocalPart()) || !child.getNamespaceURI().equals(WstopConstants.TOPIC_QNAME.getNamespaceURI())) continue;
            if (topics.contains(child.getAttribute("name").getValue())) {
                child.setAttribute(SUPPORTED_QNAME_ATTR.getLocalPart(), "true", Namespace.getNamespace((String)SUPPORTED_QNAME_ATTR.getPrefix(), (String)SUPPORTED_QNAME_ATTR.getNamespaceURI()));
            }
            if (child.getChildren() == null || child.getChildren().size() <= 0) continue;
            this.addSupportedTopicAttr(child.getChildren(), topics);
        }
    }

    public TopicSetType createTopicSetFromSupportedTopicNamespace(TopicNamespaceType topicns) throws CoreException {
        TopicSetType res = null;
        Namespace tns = Namespace.getNamespace((String)"tns", (String)topicns.getNamespace().toString());
        Element root = this.createEmptyTopicSet();
        Document doc = new Document(root);
        this.createTopicSetTree(topicns.getTopics(), root, tns, true);
        org.w3c.dom.Document domDocument = null;
        DOMOutputter converter = new DOMOutputter();
        try {
            domDocument = converter.output(doc);
        }
        catch (JDOMException e) {
            throw new CoreException((Throwable)e);
        }
        try {
            res = RefinedWstopFactory.getInstance().getWstopReader().readTopicSetType(domDocument);
        }
        catch (WstopException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    private Element createEmptyTopicSet() {
        Namespace wstop = Namespace.getNamespace((String)"wstop", (String)"http://docs.oasis-open.org/wsn/t-1");
        Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        Element root = new Element(WstConstants.TOPIC_SET_QNAME.getLocalPart(), wstop);
        root.addNamespaceDeclaration(xsi);
        root.setAttribute("schemaLocation", "http://docs.oasis-open.org/wsn/t-1 http://docs.oasis-open.org/wsn/t-1.xsd", xsi);
        return root;
    }

    private void createTopicSetTree(List<TopicType> topics, Element root, Namespace tns, boolean first) {
        Namespace wstop = Namespace.getNamespace((String)"wstop", (String)"http://docs.oasis-open.org/wsn/t-1");
        for (TopicType topic : topics) {
            Element childTopic = null;
            childTopic = first ? new Element(topic.getName(), tns) : new Element(topic.getName());
            if (ExtendedServiceNotificationImpl.isTopicSupported(topic) != null && ExtendedServiceNotificationImpl.isTopicSupported(topic).booleanValue()) {
                childTopic.setAttribute("topic", "true", wstop);
                root.addContent((Content)childTopic);
            }
            if (topic.getTopics() == null || topic.getTopics().size() <= 0) continue;
            this.createTopicSetTree(topic.getTopics(), childTopic, tns, false);
        }
    }

    public static Boolean isTopicSupported(TopicType topic) {
        Boolean res = null;
        EJaxbTopicType model = TopicTypeImpl.toJaxbModel((TopicType)topic);
        String value = (String)model.getOtherAttributes().get(SUPPORTED_QNAME_ATTR);
        if (value != null) {
            res = Boolean.valueOf(value);
        }
        return res;
    }

    static {
        Wsnb4ServUtils.initModelFactories((WsrfbfModelFactory)new WsrfbfModelFactoryImpl(), (WsrfrModelFactory)new WsrfrModelFactoryImpl(), (WsrfrlModelFactory)new WsrfrlModelFactoryImpl(), (WsrfrpModelFactory)new WsrfrpModelFactoryImpl(), (WstopModelFactory)new WstopModelFactoryImpl(), (WsnbModelFactory)new WsnbModelFactoryImpl());
    }
}

