/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.extended.service.observation.impl;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.administration.EndpointEntry;
import com.ebmwebsourcing.easyviper.administration.EndpointType;
import com.ebmwebsourcing.easyviper.administration.Endpoints;
import com.ebmwebsourcing.easyviper.administration.GetProcessDefinitionEndpoints;
import com.ebmwebsourcing.easyviper.administration.GetProcessDefinitionEndpointsResponse;
import com.ebmwebsourcing.easyviper.administration.GetProcessDefinitionsNamesResponse;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AbstractServiceImpl;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.extended.service.observation.api.ExtendedServiceObservation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.Component;

public class ExtendedServiceObservationImpl
extends AbstractServiceImpl
implements ExtendedServiceObservation {
    private Logger log = Logger.getLogger(ExtendedServiceObservationImpl.class.getName());

    public ExtendedServiceObservationImpl(Engine engine) {
        super(engine);
    }

    public void run() {
        try {
            Thread.sleep(this.getRefreshFrequency());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.log.severe("Error in extended observation service: " + e.getMessage());
        }
    }

    @Override
    public List<String> getProcessInstancesNames(QName processDefinitionName) {
        ArrayList<String> res = new ArrayList<String>();
        try {
            List processInstances = this.getEngine().getProcessInstanceRegistry().getProcessInstances();
            System.out.println("processInstances : " + processInstances);
            for (Process processInstance : processInstances) {
                System.out.println("name : " + processInstance.getName());
                System.out.println("qname :" + processDefinitionName);
                if (!processInstance.getName().startsWith(processDefinitionName.toString() + "_")) continue;
                System.out.println("add " + processInstance.getName());
                res.add(processInstance.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public String getProcessInstanceState(String processInstanceNameDataModel) {
        String processInstanceState = "Unknown";
        Process process = this.getEngine().findProcessFromName(processInstanceNameDataModel);
        if (process != null) {
            processInstanceState = process.getState().toString();
        }
        return processInstanceState;
    }

    @Override
    public String getActivityState(String processInstanceName, String activityName) {
        String activityState = "Unknown";
        Process process = this.getEngine().findProcessFromName(processInstanceName);
        if (process != null) {
            try {
                List behaviours = process.findBehaviours(Behaviour.class, true);
                for (Behaviour behaviour : behaviours) {
                    SCAHelper.getSCAHelper().startComponent(behaviour.getComponent());
                    if (!behaviour.getQName().getLocalPart().equals(activityName)) continue;
                    activityState = behaviour.getState().toString();
                    break;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (SCAException e) {
                e.printStackTrace();
            }
        }
        return activityState;
    }

    @Override
    public boolean isProcessInstanceStopped(String isProcessInstanceStoppedInputDataModel) {
        String processInstanceName = isProcessInstanceStoppedInputDataModel;
        Component c = null;
        try {
            c = SCAHelper.getSCAHelper().getFirstComponentByName(this.getEngine().getComponent(), processInstanceName);
            if (c == null) {
                return false;
            }
            Component mainExec = SCAHelper.getSCAHelper().getFirstComponentByName(c, "mainExec");
            return !SCAHelper.getSCAHelper().isStarted(mainExec);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                return false;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return false;
            }
        }
    }

    @Override
    public boolean isProcessInstanceStarted(String isProcessInstanceStartedInput) {
        boolean boo = false;
        String processInstanceName = isProcessInstanceStartedInput;
        System.out.println("rere 0");
        Component c = null;
        try {
            c = SCAHelper.getSCAHelper().getFirstComponentByName(this.getEngine().getComponent(), processInstanceName);
            if (c == null) {
                return false;
            }
            return SCAHelper.getSCAHelper().isStarted(c);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isProcessInstanceEnded(String isProcessInstanceEndedInputDataModel) {
        boolean ended = false;
        Process process = this.getEngine().findProcessFromName(isProcessInstanceEndedInputDataModel);
        if (process == null) {
            return false;
        }
        try {
            if (!SCAHelper.getSCAHelper().isStarted(SCAHelper.getSCAHelper().getFirstComponentByName(this.getEngine().getComponent(), isProcessInstanceEndedInputDataModel))) {
                return false;
            }
        }
        catch (SCAException e1) {
            e1.printStackTrace();
        }
        ended = process.getState().equals((Object)Process.State.PROCESS_ENDED);
        return ended;
    }

    @Override
    public GetProcessDefinitionEndpointsResponse getProcessDefinitionEndpoints(GetProcessDefinitionEndpoints getProcessDefinitionEndpointsInput) {
        GetProcessDefinitionEndpointsResponse res = new GetProcessDefinitionEndpointsResponse();
        Endpoints edps = new Endpoints();
        edps.getEndpointEntry();
        res.setEndpoints(edps);
        QName defQName = getProcessDefinitionEndpointsInput.getProcessDefinitionName();
        try {
            Map endpoints;
            ProcessKey pk = this.getEngine().getCore().getModel().getRegistry().findProcessKey(defQName);
            List processes = this.getEngine().getProcessInstanceRegistry().getProcessInstances(pk);
            if (processes != null && processes.size() > 0 && (endpoints = ((Process)processes.get(0)).getEndpoints()) != null) {
                for (Map.Entry endpoint : endpoints.entrySet()) {
                    EndpointType edp = new EndpointType();
                    edp.setEndpointName(((Endpoint)endpoint.getValue()).getEndpointName());
                    edp.setService(((Endpoint)endpoint.getValue()).getServiceName());
                    edp.setInterface(((Endpoint)endpoint.getValue()).getInterfaceName());
                    EndpointEntry e = new EndpointEntry();
                    e.setEndpointKey(endpoint.getKey().toString());
                    e.setEndpoint(edp);
                    res.getEndpoints().getEndpointEntry().add(e);
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public boolean isProcessInstanceSuspended(String isProcessInstanceSuspendedInput) {
        String processInstanceName = isProcessInstanceSuspendedInput;
        Component c = null;
        try {
            c = SCAHelper.getSCAHelper().getFirstComponentByName(this.getEngine().getComponent(), processInstanceName);
            if (SCAHelper.getSCAHelper().isStarted(c)) {
                System.out.println("Process Instance State : " + ((Process)c.getFcInterface("service")).getParentExecution().getState());
                return ((Process)c.getFcInterface("service")).getParentExecution().getState().equals((Object)Execution.State.SUSPENDED);
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public GetProcessDefinitionsNamesResponse.ProcessDefinitionNamesDM getProcessDefinitionsNames() {
        GetProcessDefinitionsNamesResponse.ProcessDefinitionNamesDM res = new GetProcessDefinitionsNamesResponse.ProcessDefinitionNamesDM();
        try {
            List processDefinitions = this.getEngine().getCore().getModel().getRegistry().getAllProcessDefinitions();
            for (ProcessDefinition processDefinition : processDefinitions) {
                res.getProcessDefinitionName().add(processDefinition.getQName());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return res;
    }
}

