package com.ebmwebsourcing.escapnote10.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectSchemaBindingImpl;
import com.ebmwebsourcing.escapnote10.api.Constants;


public final class XmlObjectSchemaBindingImpl extends
        AbstractXmlObjectSchemaBindingImpl {

    @Override
    public String getName() {
        return "escapnote10-impl";
    }
    
    @Override
    public String getOriginatingSchemaDir() {
        return "schema/escapnote10";
    }

    @Override
    public String getOriginatingSchemaName() {
        return "escapnote10.xsd";
    }

    @Override
    public Package getModelObjectPackage() {
        return easybox.note.protocol.alerting.common.petalslink.com._1.ObjectFactory.class.getPackage();
    }

    
    @Override
    public String getOriginatingSchemaNamespaceURI() {
        return Constants.ESCAPNOTE_NS_URI;
    }
    
    @Override
    public String getOriginatingSchemaPreferredNamespacePrefix() {
        return Constants.ESCAPNOTE_NS_PREFERRED_PREFIX;
    }
    
    
    
    @SuppressWarnings("unchecked")
    @Override
    public Class<? extends XmlObject>[] getFactorableClasses() {
        List<Class<? extends XmlObject>> factorableClasses = new ArrayList<Class<? extends XmlObject>>();
        
        // type
        factorableClasses.add(AlertNoteDefinitionTypeImpl.class);
        factorableClasses.add(EndpointTypeImpl.class);
        
        // element
        factorableClasses.add(AlertNoteDefinitionImpl.class);
        factorableClasses.add(ResponderIdentifierImpl.class);
        factorableClasses.add(InitiatorIdentifierImpl.class);
        
        return factorableClasses.toArray(new Class[factorableClasses.size()]);
    }
    
    
    @Override
    protected XmlObject doWrap(XmlContext xmlContext,
            Constructor<? extends XmlObject> xmlObjectImplConstructor,
            ModelObject ModelObject)
            throws InstantiationException, IllegalAccessException,
            InvocationTargetException {
        return xmlObjectImplConstructor.newInstance(xmlContext, ModelObject);
    }

}
