/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.esstar.management;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;

import org.jdom.JDOMException;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Notify;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.ObjectFactory;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Subscribe;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Unsubscribe;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.GetResourcePropertyResponse;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbConnectToGovernance;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDescriptorType;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUnconnectToGovernance;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUndeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUndeployResponse;
import esstar.petalslink.com.data.management.admin._1.GetAdditionalContent;
import esstar.petalslink.com.data.management.admin._1.GetAdditionalContentResponse;
import esstar.petalslink.com.data.management.admin._1.GetContent;
import esstar.petalslink.com.data.management.admin._1.GetContentResponse;
import esstar.petalslink.com.data.management.admin._1.GetExecutionEnvironmentInformation;
import esstar.petalslink.com.data.management.admin._1.GetExecutionEnvironmentInformationResponse;
import esstar.petalslink.com.data.management.admin._1.GetResourceIdentifiers;
import esstar.petalslink.com.data.management.admin._1.GetResourceIdentifiersResponse;
import esstar.petalslink.com.data.management.admin._1.Stop;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import esstar.petalslink.com.service.management.admin._1_0.AdminManagement;

public class AdminManagementClientSOAP implements AdminManagement {

	protected String address = null;

	private SOAPSender soapSender;

	static{
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(easybox.esstar.petalslink.com.management.model.datatype._1.ObjectFactory.class,
					com.ebmwebsourcing.wsstar.jaxb.notification.base.ObjectFactory.class,
					esstar.petalslink.com.data.management.admin._1.ObjectFactory.class,
					com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}

	private static easybox.esstar.petalslink.com.management.model.datatype._1.ObjectFactory objectFactory = new easybox.esstar.petalslink.com.management.model.datatype._1.ObjectFactory();
	private static com.ebmwebsourcing.wsstar.jaxb.notification.base.ObjectFactory wsstarFactory = new ObjectFactory();
	private static com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.ObjectFactory rscFactory = new com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.ObjectFactory();


	public AdminManagementClientSOAP(String address) {
		this.address = address;
		soapSender = new SOAPSender();
	}
	
	public String getAddress() {
		return address;
	}

	@Override
	public SubscribeResponse subscribe(Subscribe subscribeRequest)
			throws UnacceptableInitialTerminationTimeFault, TopicExpressionDialectUnknownFault,
			InvalidTopicExpressionFault, NotifyMessageNotSupportedFault, TopicNotSupportedFault,
			UnsupportedPolicyRequestFault, ResourceUnknownFault, InvalidFilterFault,
			InvalidProducerPropertiesExpressionFault, UnrecognizedPolicyRequestFault,
			InvalidMessageContentExpressionFault, SubscribeCreationFailedFault {

		SubscribeResponse res = new SubscribeResponse();
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(subscribeRequest));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/subscribe");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					TopicNotSupportedFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, TopicNotSupportedFault.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new TopicNotSupportedFault("Business Fault", fault);
				} else {
					throw new TopicNotSupportedFault("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, SubscribeResponse.class);
		} catch (Exception e) {
			throw new TopicNotSupportedFault("Technical Fault", e);
		} 

		return res;
	}

	public SubscribeResponse subscribe(Document subscribeRequest)
			throws UnacceptableInitialTerminationTimeFault, TopicExpressionDialectUnknownFault,
			InvalidTopicExpressionFault, NotifyMessageNotSupportedFault, TopicNotSupportedFault,
			UnsupportedPolicyRequestFault, ResourceUnknownFault, InvalidFilterFault,
			InvalidProducerPropertiesExpressionFault, UnrecognizedPolicyRequestFault,
			InvalidMessageContentExpressionFault, SubscribeCreationFailedFault {

		SubscribeResponse res = new SubscribeResponse();
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(subscribeRequest);
			System.out.println("SOAP REQUEST: \n" + XMLPrettyPrinter.prettyPrint(subscribeRequest));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/subscribe");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					TopicNotSupportedFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, TopicNotSupportedFault.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new TopicNotSupportedFault("Business Fault", fault);
				} else {
					throw new TopicNotSupportedFault("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, SubscribeResponse.class);
		} catch (Exception e) {
			throw new TopicNotSupportedFault("Technical Fault", e);
		} 

		return res;
	}

	@Override
	public GetExecutionEnvironmentInformationResponse getExecutionEnvironmentInformation(
			GetExecutionEnvironmentInformation parameters) throws ManagementException {

		GetExecutionEnvironmentInformationResponse res = new GetExecutionEnvironmentInformationResponse();
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/getExecutionEnvironmentInformation");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					ManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, ManagementException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new ManagementException("Business Fault", fault);
				} else {
					throw new TopicNotSupportedFault("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, GetExecutionEnvironmentInformationResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;

	}


	public EJaxbDeployementReport deploy(URL descriptorURL) throws ManagementException {
		if (descriptorURL == null) {
            throw new ManagementException("Descriptor file can not be null");
        }


        EJaxbDescriptorType descriptor = new EJaxbDescriptorType();
        descriptor.setFileURI(descriptorURL.toString());
       
        EJaxbDeploy request = new EJaxbDeploy();
        request.setMainResource(descriptor);
        EJaxbDeployResponse response = deploy(request);
        return response.getDeployementReport();
	}



	public EJaxbDeployementReport deploy(File descriptorFile, File[] resources) throws ManagementException {


		if (descriptorFile == null) {
			throw new ManagementException("descriptor file is null");
		}

		if (!descriptorFile.exists() || !descriptorFile.isFile()) {
			throw new ManagementException("Descriptor file " +  descriptorFile.getName() + " does not exists or is not a file");
		}

		EJaxbDescriptorType descriptor = new EJaxbDescriptorType();
		descriptor.setFileURI(descriptorFile.toURI().toString());
		descriptor.setAttachment(new DataHandler(new FileDataSource(descriptorFile)));

		List<EJaxbDescriptorType> list = new ArrayList<EJaxbDescriptorType>();
		if (resources != null) {
			for (File file : resources) {
				if (file != null && file.exists() && file.isFile()) {
					EJaxbDescriptorType resource = new EJaxbDescriptorType();
					resource.setFileURI(file.toURI().toString());
					resource.setAttachment(new DataHandler(new FileDataSource(file)));
					list.add(resource);
				} else {
					// warning
				}
			}
		}
		EJaxbDeploy request = new EJaxbDeploy();
		request.setMainResource(descriptor);
		request.getResources().addAll(list);
		EJaxbDeployResponse response = deploy(request);
		return response.getDeployementReport();


	}


	@Override
	public EJaxbDeployResponse deploy(EJaxbDeploy parameters) throws ManagementException {

		EJaxbDeployResponse res = new EJaxbDeployResponse();
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/deploy");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					ManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, ManagementException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new ManagementException("Business Fault", fault);
				} else {
					throw new TopicNotSupportedFault("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbDeployResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;


	}

	@Override
	public void stop() {

		try {
			Stop payload = new Stop();
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/stop");
			if(soapResponse != null && SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					SOAPException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, SOAPException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
				} 
			}

		} catch (JDOMException e) {
			e.printStackTrace();
		} catch (SOAException e) {
			e.printStackTrace();
		} catch (SOAPException e) {
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		}

	}

	@Override
	public GetResourceIdentifiersResponse getResourceIdentifiers(GetResourceIdentifiers parameters)
			throws ManagementException {

		GetResourceIdentifiersResponse res = new GetResourceIdentifiersResponse();
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/getResourceIdentifiers");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					ManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, ManagementException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new ManagementException("Business Fault", fault);
				} else {
					throw new TopicNotSupportedFault("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, GetResourceIdentifiersResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;


	}

	@Override
	public UnsubscribeResponse unsubscribe(Unsubscribe unsubscribeRequest)
			throws UnableToDestroySubscriptionFault, ResourceUnknownFault {

		UnsubscribeResponse res = new UnsubscribeResponse();
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(unsubscribeRequest));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/unSubscribe");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					ResourceUnknownFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, ResourceUnknownFault.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new ResourceUnknownFault("Business Fault", fault);
				} else {
					throw new TopicNotSupportedFault("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, UnsubscribeResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;

	}

	@Override
	public GetAdditionalContentResponse getAdditionalContent(
			GetAdditionalContent getAdditionalContentRequest) throws ManagementException {

		GetAdditionalContentResponse res = new GetAdditionalContentResponse();
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(getAdditionalContentRequest));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/getAdditionalContent");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					ManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, ManagementException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new ManagementException("Business Fault", fault);
				} else {
					throw new TopicNotSupportedFault("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, GetAdditionalContentResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;

	}

	@Override
	public GetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest)
			throws InvalidResourcePropertyQNameFault, ResourceUnavailableFault,
			ResourceUnknownFault {
		GetResourcePropertyResponse res = new GetResourcePropertyResponse();
		try{
			Document payload = SOAJAXBContext.getInstance().unmarshallAnyElement(rscFactory.createGetResourceProperty(getResourcePropertyRequest));

			Node root = payload.createElementNS(getResourcePropertyRequest.getNamespaceURI(), getResourcePropertyRequest.getLocalPart());
			payload.adoptNode(root);

			Document soapRequest = SOAPSender.createSOAPMessageRequest(payload);
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/getResourceProperty");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					ResourceUnknownFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, ResourceUnknownFault.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new ResourceUnknownFault("Business Fault", fault);
				} else {
					throw new TopicNotSupportedFault("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get GetResourcePropertyResponse
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, GetResourcePropertyResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;
	}

	@Override
	public GetContentResponse getContent(GetContent parameters) throws ManagementException {
		GetContentResponse res = new GetContentResponse();
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/getContent");
			System.out.println("dddddddddddddddd soapResponse:\n" + XMLPrettyPrinter.prettyPrint(soapResponse));
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					ManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, ManagementException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new ManagementException("Business Fault", fault);
				} else {
					throw new TopicNotSupportedFault("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, GetContentResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;
	}

	@Override
	public void notify(Notify notify) {
		try {
			Notify payload = new Notify();
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/notify");
			if(soapResponse != null && SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					SOAPException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, SOAPException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
				} 
			}

		} catch (JDOMException e) {
			e.printStackTrace();
		} catch (SOAException e) {
			e.printStackTrace();
		} catch (SOAPException e) {
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		}
	}

	@Override
	public void unconnectToGovernance(String address)
			throws ManagementException {
		try {
			EJaxbUnconnectToGovernance payload = new EJaxbUnconnectToGovernance();
			payload.setAddress(address);
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/unconnectToGovernance");
			if(soapResponse != null && SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					SOAPException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, SOAPException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
				} else {
					throw new ManagementException("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

		} catch (JDOMException e) {
			e.printStackTrace();
		} catch (SOAException e) {
			e.printStackTrace();
		} catch (SOAPException e) {
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		}

	}

	@Override
	public void connectToGovernance(String address)
			throws ManagementException {
		try {
			EJaxbConnectToGovernance payload = new EJaxbConnectToGovernance();
			payload.setAddress(address);
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.esstar/service/management/admin/1.0/connectToGovernance");
			if(soapResponse != null && SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					SOAPException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, SOAPException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
				} else {
					throw new ManagementException("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

		} catch (JDOMException e) {
			e.printStackTrace();
		} catch (SOAException e) {
			e.printStackTrace();
		} catch (SOAPException e) {
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		}
	}

	@Override
	public EJaxbUndeployResponse undeploy(EJaxbUndeploy parameters)
			throws ManagementException {
		EJaxbUndeployResponse res = new EJaxbUndeployResponse();
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/undeploy");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					ManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, ManagementException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new ManagementException("Business Fault", fault);
				} else {
					throw new TopicNotSupportedFault("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbUndeployResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;
	}

}
