/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.rawreport10.api.type;

import java.util.Date;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlObject;

public interface ReportType extends XmlObject {

	String getExchangeId();
	
	void setExchangeId(String value);
	
	boolean hasExchangeId();
	
	
	
	Date getDateInGMT();
	
	void setDateInGMT(Date value);
	
	boolean hasDateInGMT();
	
	
	
	String getConsumerEndpointAddress();
	
	void setConsumerEndpointAddress(String value);
	
	boolean hasConsumerEndpointAddress();
	
	
	
	QName getServiceQName();
	
	void setServiceQName(QName value);
	
	boolean hasServiceQName();
	
	
	
	String getOperationName();
	
	void setOperationName(String value);
	
	boolean hasOperationName();
	
	
	
	QName getInterfaceQName() ;
	
	void setInterfaceQName(QName value);
	
	boolean hasInterfaceQName();
	
	
	
	String getProviderEndpointAddress();
	
	void setProviderEndpointAddress(String value);
	
	boolean hasProviderEndpointAddress();
	
	
	
	String getEndpointName();
	
	void setEndpointName(String value);
	
	boolean hasEndpointName();
	
	
	long getContentLength();
	
	void setContentLength(long value);

	
	
	boolean isDoesThisResponseIsAnException();
	
	void setDoesThisResponseIsAnException(boolean value);
	
	
	Object getAny();
	
	void setAny(Object value);
    
	boolean hasAny() ;
	

	
	void setTimeStamp(TimeStampType t);
	
	TimeStampType getTimeStamp();
	
	boolean hasTimeStamp();
	

}
