/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.esrawreport10.impl;



import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.Report;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.ReportListType;

import easybox.petalslink.com.esrawreport._1.EJaxbReportListType;
import easybox.petalslink.com.esrawreport._1.EJaxbReportType;


class ReportListTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbReportListType> implements
ReportListType {

	protected ReportListTypeImpl(XmlContext xmlContext, EJaxbReportListType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbReportListType> getCompliantModelClass() {
		return EJaxbReportListType.class;
	}


	@Override
	public Report[] getReports() {
		return createChildrenArray(getModelObject()
				.getReport(), EJaxbReportType.class,
				ANY_QNAME, Report.class);
	}


	@Override
	public void addReport(Report pe) {
		addToChildren(getModelObject().getReport(), pe);
	}


	@Override
	public void removeReport(Report pe) {
		removeFromChildren(getModelObject().getReport(), pe);
	}


	@Override
	public void clearReports() {
		clearChildren(getModelObject().getReport(),
				EJaxbReportType.class, ANY_QNAME);
	}




}
