/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.petalslink.esstar.essynchronizer.impl.service.notification;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.parsers.ParserConfigurationException;

import org.ow2.petals.notifier.NotificationConsumerDecorator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.esstar.management.AdminManagementClientSOAP;
import com.petalslink.esstar.essynchronizer.impl.AbstractResourcesManager;
import com.petalslink.esstar.essynchronizer.impl.ConnexionManagerImpl;
import com.petalslink.esstar.essynchronizer.impl.thread.ResourceIdSynchronizerThread;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotificationMessageHolderType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;

public class NotificationResourcesConsumer implements NotificationConsumerDecorator {

	private static Logger LOG = Logger.getLogger(ConnexionManagerImpl.class.getName());


	private String address = null;
	
	private AbstractResourcesManager manager = null;
	
	private AdminManagementClientSOAP client = null;

	public NotificationResourcesConsumer(String address, AdminManagementClientSOAP client, AbstractResourcesManager manager) {
		this.address = address;
		this.manager = manager;
		this.client = client;
	}



	
	@Override
	public synchronized void notify(EJaxbNotify notify) {
		System.out
		.println("***************************** NEW NOTIFICATION ***********************");
		try {
			System.out.println(XMLPrettyPrinter.prettyPrint(SOAJAXBContext.getInstance().unmarshallAnyElement(notify)));
		} catch (SOAException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		try {
			for(EJaxbNotificationMessageHolderType nmh: notify.getNotificationMessage()) {
				EJaxbResourceIdentifier rid =  null;
				if(nmh.getMessage().getAny() instanceof EJaxbResourceIdentifier) {
					rid = (EJaxbResourceIdentifier) nmh.getMessage().getAny();
				} else if(nmh.getMessage().getAny() instanceof Element) {
					Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
					doc.appendChild(doc.importNode((Element)nmh.getMessage().getAny(), true));
					
					rid = SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbResourceIdentifier.class);
				}
				
				
				List<EJaxbResourceIdentifier> rids = new ArrayList<EJaxbResourceIdentifier>();
				rids.add(rid);
				ResourceIdSynchronizerThread synchro = new ResourceIdSynchronizerThread(rids, address, this.client, this.manager);
				synchro.run();
			}
		} catch (SOAException e) {
			LOG.warning(e.getMessage());
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			LOG.warning(e.getMessage());
			e.printStackTrace();
		}
	}

}
