/**
 * geasyschema-domain - Domain Objects Implementation for XML Schema Definition Language - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasyschema.domain;

import com.ebmwebsourcing.geasyschema.domain.api.IElement;

public class Element implements IElement{
	
	private static final long serialVersionUID = 4366799617590316515L;
	
	private String name = "";
	private String type = "";
	
	protected Element() {
		
	}
	
	public Element(String name) {
		this.setName(name);
	}
	
	public Element(String name, String type){
		this.setName(name);
		this.setType(type);
	}
	
	@Override
	public String getName() {
		return name;
	}
	
	@Override
	public void setName(String name) {
		if(name != null){
			this.name = name;
		} else {
			this.name = "";
		}
	}
	
	@Override
	public String getType() {
		return type;
	}
	
	@Override
	public void setType(String type) {
		if(type != null){
			this.type = type;
		} else {
			this.type = "";
		}
	}

	@Override
	public int hashCode() {
		return name.hashCode();
	}

	@Override
	public boolean equals(Object o){
		if(o instanceof IElement){
			return name.equals(((IElement) o).getName());
		} else {
			return false;
		}
	}

}
