/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor;

import java.util.ArrayList;

import com.ebmwebsourcing.geasytools.diagrameditor.api.events.loader.IDiagramViewLoaderHandler;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.loader.IElementLoadedEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.loader.ILoadErrorEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.loader.ILoadSuccessEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.loader.ILoadingStateChangeEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.DiagramValidationException;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.INewUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IRemoveUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IResizeRequestEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.ISelectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUIPanelHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUnselectedElementsEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.UndoRedoSession;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;

/**
 * Handles models editor edition. Model Rendering (through editors view) , Undo, Redo ,
 * Selections etc ... based on user interactions on diagram
 * 
 * @author nfleury
 */
public class DiagramEditorModelBuilder {

	
	private UndoRedoSession undoRedoSession;
	
	private IDiagramView diagram;
	private DiagramController controller;
	
	public DiagramEditorModelBuilder(IDiagramView diagram, DiagramController diagramController) {
		
		this.diagram 			= diagram;
		this.controller 		= diagramController;
		this.undoRedoSession 	= new UndoRedoSession();
		this.addListeners();
		this.initialize();
	}
	
	private void initialize(){
		
		//by default select diagram editor model
		ArrayList<IEditorModel> selectedEditorModels = new ArrayList<IEditorModel>();
		selectedEditorModels.add(diagram.getEditorModel());
		controller.getEditorView().setSelectedModels(selectedEditorModels);
		controller.getEditorView().refresh();
		
		//set main model element on diagram 
		diagram.setMainModel(controller.getMainModelElementWithoutValidation());

	
	}
	
	public void addListeners(){
		
		//on finish loading
		controller.addLoaderHandler(new IDiagramViewLoaderHandler() {
			
			@Override
			public void onLoadingStateChange(ILoadingStateChangeEvent event) {

				
			}
			
			@Override
			public void onLoadSuccess(ILoadSuccessEvent event) {
			
				//=> select diagram editor model
				ArrayList<IEditorModel> selectedEditorModels = new ArrayList<IEditorModel>();
				selectedEditorModels.add(diagram.getEditorModel());
				controller.getEditorView().setTemplate(diagram.getFormTemplate());
				controller.getEditorView().setSelectedModels(selectedEditorModels);
				controller.getEditorView().refresh();
				
				
			}
			
			@Override
			public void onError(ILoadErrorEvent event) {
			
				
			}
			
			@Override
			public void onElementLoaded(IElementLoadedEvent event) {
			
				
			}
		});
		
		
		//when diagram is selected
		diagram.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				
				
				//When nothing is selected => select diagram editor model
				ArrayList<IEditorModel> selectedEditorModels = new ArrayList<IEditorModel>();
				selectedEditorModels.add(diagram.getEditorModel());
				controller.getEditorView().setTemplate(diagram.getFormTemplate());
				controller.getEditorView().setSelectedModels(selectedEditorModels);
				controller.getEditorView().refresh();
				
				diagram.setMainModel(controller.getMainModelElementWithoutValidation());
				
				
			}
		});
		
		diagram.addUIPanelHandler(new IUIPanelHandler() {
			
			@Override
			public void onUnSelectUIElement(
					IUnselectedElementsEvent unselectedElementsEvent) {
				

				
				
			}
			
			@Override
			public void onSelectUIElement(ISelectedElementsEvent selectedElementsEvent) {
				
				ArrayList<IEditorModel> selectedEditorModels = new ArrayList<IEditorModel>();
				
				IDiagramElementView elView = null;
				
				diagram.setMainModel(controller.getMainModelElementWithoutValidation());
				
				
				//Get all editor models for selected elements
				for(IUIElement uielement:selectedElementsEvent.getSelectedElements().values()){
				
					if (uielement instanceof IDiagramElementView){
						
						IDiagramElementView uidiagramElement = (IDiagramElementView) uielement;
						
						elView = uidiagramElement;
						
						selectedEditorModels.add(uidiagramElement.getEditorModel());
					
						
					}
				
				}
				
				//if only 1 element is selected
				if (selectedElementsEvent.getSelectedElements().size()==1) controller.getEditorView().setTemplate(elView.getFormTemplate());
				
				
				controller.getEditorView().setSelectedModels(selectedEditorModels);
				controller.getEditorView().refresh();
				
			}
			
			@Override
			public void onRemoveUIElement(IRemoveUIElementEvent removeElementEvent) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onNewUIElement(INewUIElementEvent addElementEvent) {
				
				
				//when adding an element get the EditorModel and register it to 
				//current undo redo session
				if (addElementEvent.getNewElement() instanceof IDiagramElementView){
					
					IDiagramElementView diagramElement = (IDiagramElementView) addElementEvent.getNewElement();
					
					//register editor model to undoredosession
					undoRedoSession.registerModel(diagramElement.getEditorModel());
					
					//listen update on editor model to update graphic state
					controller.getGraphicStateHandler().listen(diagramElement);
					
					//listen update on editor model to update syntax model state
					controller.getSyntaxModelBinderHandler().listen(diagramElement);
					
					
					//select the new element
//					ArrayList<IEditorModel> selectedEditorModels = new ArrayList<IEditorModel>();
//					selectedEditorModels.add(diagramElement.getEditorModel());
//					controller.getEditorView().setSelectedModels(selectedEditorModels);
//					controller.getEditorView().refresh();
					
				}
				
				
			}

			@Override
			public void onResizeRequest(IResizeRequestEvent event) {
				// TODO Auto-generated method stub
				
			}
		});
		
		
		
		
	}
	
	
	
}
