/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.impl.events.loader;

import com.ebmwebsourcing.geasytools.diagrameditor.api.events.loader.IDiagramViewLoaderHandler;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.loader.IElementLoadedEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.google.gwt.event.shared.GwtEvent;

public class ElementLoadedEvent extends GwtEvent<IDiagramViewLoaderHandler> implements IElementLoadedEvent{
	
	public static Type<IDiagramViewLoaderHandler> TYPE = new Type<IDiagramViewLoaderHandler>();
	
	private IDiagramElementView loadedElement;
	
	public ElementLoadedEvent(IDiagramElementView loadedElement) {
		this.loadedElement = loadedElement;
	}
	

	@Override
	public Type getAssociatedType() {
		return TYPE;
	}

	@Override
	public IDiagramElementView getLoadedElement() {
		return loadedElement;
	}

	@Override
	protected void dispatch(IDiagramViewLoaderHandler handler) {
		handler.onElementLoaded(this);
	}

}
