/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.diagrameditor;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IHasEditorModel;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.INewUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IRemoveUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IResizeRequestEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.ISelectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUIPanelHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUnselectedElementsEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.lookup.IHasLookupProxy;

public class ContextBuilder {

	private IDiagramView diagramView;
	private DiagramController controller;
	
	public ContextBuilder(DiagramController contoller) {
	
		this.controller 	= contoller;
		this.diagramView 	= contoller.getDiagramView();
		initialize();
	}
	
	protected void setContext(IHasEditorModel hasEditorModel){
		
		IEditorModel model = hasEditorModel.getEditorModel();
		
		IHasLookupProxy proxy = (IHasLookupProxy) model;

		proxy.register(hasEditorModel);
		if (controller.getEditorView()!=null) proxy.register(controller.getEditorView());
		


		
	}
	
	public void initialize(){
		
		setContext(diagramView);
		
		diagramView.addUIPanelHandler(new IUIPanelHandler() {
			
			@Override
			public void onUnSelectUIElement(
					IUnselectedElementsEvent unselectedElementsEvent) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onSelectUIElement(ISelectedElementsEvent selectedElementsEvent) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onResizeRequest(IResizeRequestEvent event) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onRemoveUIElement(IRemoveUIElementEvent removeElementEvent) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onNewUIElement(INewUIElementEvent newElementEvent) {
				
				if (newElementEvent.getNewElement() instanceof IDiagramElementView){
					
					IDiagramElementView elView = (IDiagramElementView) newElementEvent.getNewElement();

					setContext(elView);
					
				}
				
			}
		});
		
	}
}
