/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.events.validation.ValidationFailureEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.events.validation.ValidationStartEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.events.validation.ValidationSuccessEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.events.validation.ValidationWarningEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.RuleLevel;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;

public class DiagramValidationHandler {

	
	private DiagramController controller;
	private IDiagramView diagramView;
	
	
	public DiagramValidationHandler(DiagramController controller,IDiagramView diagramUI) {
			this.controller = controller;
			this.diagramView = diagramUI;
	}
	
	
	public void validate(){
		
		HashSet<IConformityRule> rulesInFailure = new HashSet<IConformityRule>();
		HashSet<IConformityRule> rulesInWarning = new HashSet<IConformityRule>();
		
		this.controller.fireEvent(new ValidationStartEvent());
		
		//1- validate each element in actual diagram
		for(IUIElement el:diagramView.getUIElements().values()){
			
			IDiagramElementView elView = (IDiagramElementView) el;

			
			if (elView.getConformityRules()!=null){
				for(IDiagramElementViewConformityRule rule:elView.getConformityRules()){
					
					boolean isConform = rule.isConform(elView); 
					
					if (isConform==false &&rule.getRuleLevel()==RuleLevel.ERROR){
						
						rulesInFailure.add(rule);
						
					}else if (isConform==false && rule.getRuleLevel()==RuleLevel.WARNING){
						
						rulesInWarning.add(rule);
						
					}
				}
			}

		}
		
		//2- validate the diagram itself
		for(IDiagramViewConformityRule rule : diagramView.getConformityRules()){
			
			boolean isConform = rule.isConform(diagramView);
			
			if (isConform==false &&rule.getRuleLevel()==RuleLevel.ERROR){
				
				rulesInFailure.add(rule);
				
			}else if (isConform==false && rule.getRuleLevel()==RuleLevel.WARNING){
				
				rulesInWarning.add(rule);
				
			}
			
			
		}
		
		
		
		
		
		//fire success event if every elements are conforms
		if (rulesInFailure.size()==0 && rulesInWarning.size()==0){
			
			this.controller.getNotificationRegistry().setRulesInFailure(rulesInFailure);
			this.controller.getNotificationRegistry().setRulesInWarning(rulesInWarning);
			this.controller.fireEvent(new ValidationSuccessEvent());
			
		//fire failure event if nonconformRules contains some errors
		}else if (rulesInFailure.size()>0){
			
			this.controller.fireEvent(new ValidationFailureEvent(rulesInFailure, rulesInWarning));
			this.controller.getNotificationRegistry().setRulesInFailure(rulesInFailure);
			this.controller.getNotificationRegistry().setRulesInWarning(rulesInWarning);
			
		//fire warning event if nonconformRules contains no error but only warnings	
		}else if (rulesInFailure.size()==0 && rulesInWarning.size()>0){

			this.controller.getNotificationRegistry().setRulesInWarning(rulesInWarning);
			this.controller.getNotificationRegistry().setRulesInFailure(rulesInFailure);
			this.controller.fireEvent(new ValidationWarningEvent(rulesInWarning));

		}		
		
	}
	
}
