/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.diagrameditor;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IHasDefaultChildren;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagram;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IShape;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.INewUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IRemoveUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IResizeRequestEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.ISelectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUIPanelHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUnselectedElementsEvent;

/**
 * Handlers used only in user interaction mode. These handlers are deactivated while loading a diagram 
 * 
 * @author nfleury
 *
 */
public class UIModeHandlers {

	private DiagramController diagramController;
	
	private IUIPanelHandler defaultChildrenHandler;
	
	public UIModeHandlers(DiagramController diagramController) {
		
		this.diagramController = diagramController;
		
		addListeners();
		
		activate();
		
	}
	
	public void activate(){
		diagramController.getDiagramView().addUIPanelHandler(defaultChildrenHandler);
	}
	
	public void deactivate(){
		diagramController.getDiagramView().removeUIPanelHandler(defaultChildrenHandler);
	}
	
	private void addListeners(){
		
		
		this.defaultChildrenHandler = new IUIPanelHandler() {
			
			@Override
			public void onUnSelectUIElement(
					IUnselectedElementsEvent unselectedElementsEvent) {

				
			}
			
			@Override
			public void onSelectUIElement(ISelectedElementsEvent selectedElementsEvent) {

				
			}
			
			@Override
			public void onResizeRequest(IResizeRequestEvent event) {

				
			}
			
			@Override
			public void onRemoveUIElement(IRemoveUIElementEvent removeElementEvent) {

				
			}
			
			@Override
			public void onNewUIElement(INewUIElementEvent newElementEvent) {
				
				
				if (newElementEvent.getNewElement() instanceof IDiagramElementView){
					
					IDiagramElementView newDiView = (IDiagramElementView) newElementEvent.getNewElement();
					
					if (newDiView.getDiagramElement() instanceof IShape){
						IShape shape  = (IShape) newDiView.getDiagramElement();
						shape.getBounds().setWidth(newDiView.getWidth());
						shape.getBounds().setHeight(newDiView.getHeight());
					}
					
					IDiagramElement diElement = newDiView.getDiagramElement();
					//if new element has default children load them
					if (newDiView instanceof IHasDefaultChildren){
						
						IHasDefaultChildren hasChilren = (IHasDefaultChildren) newDiView;
						
						for(IDiagramElement di:hasChilren.getChildrenDIModels()){
							//add child to plane
							getDiagramInterchangeModel().addDiagramElement(di);
							//assign new parent
							diElement.addDiagramElement(di);
							diagramController.diagramViewLoader.loadDiagramElementView(di, (IContainer) newDiView);

						}
						
						
					}
					
				}
				
				
			}
		};
		

		
	}
	
	
	private IDiagram getDiagramInterchangeModel(){		
		return diagramController.getDiagramView().getDiagram();
	}
	
	
}
