/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.diagrameditor.helper.designer.event;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IModelElement;
import com.google.gwt.event.shared.GwtEvent;

public class DiagramElementPropertyChangeEvent extends GwtEvent<IDiagramDesignerHandler>{
	
	public static Type<IDiagramDesignerHandler> TYPE = new Type<IDiagramDesignerHandler>();
	
	private String propertyName;
	
	private IDiagramElementView diagramElementView;
	
	private Object value;
	
	public DiagramElementPropertyChangeEvent(String propertyName,Object value,IDiagramElementView diagramElementView) {
		this.propertyName = propertyName;
		this.diagramElementView = diagramElementView;
		this.value = value;
	}
	
	public String getPropertyName() {
		return propertyName;
	}
	
	public Object getValue() {
		return value;
	}
	
	public IDiagramElementView getDiagramElementView() {
		return diagramElementView;
	}
	
	public IModelElement getSyntaxModel(){
		return diagramElementView.getDiagramElement().getModelElement();
	}
	
	public IEditorModel getEditorModel(){
		return diagramElementView.getEditorModel();
	}
	
	@Override
	protected void dispatch(IDiagramDesignerHandler handler) {
		handler.onDiagramElementPropertyChange(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IDiagramDesignerHandler> getAssociatedType() {
		return TYPE;
	}

	

}
