/**
 * geasy-graph - A project to deal with graph problematics: pathfinding etc... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasygraph.impl;

import java.util.HashSet;
import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.geasygraph.api.IGraph;
import com.ebmwebsourcing.geasytools.geasygraph.api.INode;
import com.ebmwebsourcing.geasytools.geasygraph.api.IPathFinder;

public abstract class PathFinder implements IPathFinder{
	
	private INode source;
	private INode target;
	private IGraph graph;
	
	private HashSet<INode> nonWalkableNodes;
	
	
	public PathFinder(IGraph graph,INode source,INode target) {
		this.source = source;
		this.target = target;
		this.graph 	= graph;
		this.nonWalkableNodes = new HashSet<INode>();
	}
	
	
	
	@Override
	public void addNonWalkableNode(INode nonwalkablenode) {
		this.nonWalkableNodes.add(nonwalkablenode);
	}

	@Override
	public IGraph getGraph() {
		return graph;
	}

	@Override
	public HashSet<INode> getNonWalkableNodes() {
		return this.nonWalkableNodes;
	}

	@Override
	public abstract LinkedHashSet<INode> getShortestPath();

	@Override
	public INode getSource() {
		return source;
	}

	@Override
	public INode getTarget() {
		return target;
	}

}
