/**
 * geasy-graph - A project to deal with graph problematics: pathfinding etc... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasygraph.impl.alphastar;


import com.ebmwebsourcing.geasytools.geasygraph.api.alphastar.IAlphaNode;
import com.ebmwebsourcing.geasytools.geasygraph.impl.Node;

public class AlphaNode extends Node implements IAlphaNode{

	private IAlphaNode parentNode;
	
	private double G;
	private double H;
	private double F;

	public AlphaNode(String id, float x, float y) {
		super(id, x, y);
	}
	

	public IAlphaNode getParentNode() {
		return parentNode;
	}

	@Override
	public double getFCost() {
		return F;
	}

	@Override
	public double getGCost() {
		return G;
	}

	@Override
	public double getHCost() {
		return H;
	}

	@Override
	public void setFCost(double f) {
		this.F = f;
	}

	@Override
	public void setGCost(double g) {
		this.G = g;
	}

	@Override
	public void setHCost(double h) {
		this.H = h;
	}

	@Override
	public void setParentNode(IAlphaNode node) {
		this.parentNode = node;
	}
	
	public String toString() {
		return "Node[id:"+this.getId()+",F:"+F+",G:"+G+",H:"+H+", position:"+this.getX()+","+this.getY()+"]";
	}
	
	
}
