/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.core.impl;

import com.ebmwebsourcing.geasytools.geasysvg.core.api.ICircle;
import com.google.gwt.user.client.Element;

public class Circle extends SVGElement implements ICircle {
	
	private float radius;
	
	public Circle(Element element,float x, float y,float radius) {
		super(element,x, y);
		
		this.radius = radius;
	}



	@Override
	public float getRadius() {
		return radius;
	}
	
	
	@Override
	public float getWidth() {
		return ((ICircle)this.impl).getWidth();
	}
	
	
	@Override
	public float getHeight() {
		return ((ICircle)this.impl).getHeight();
	}
	
	@Override
	public void setX(float x) {
		this.impl.setX(x);
		super.setY(x);
	}
	
	
	@Override
	public void setY(float y) {
		this.impl.setY(y);
		super.setY(y);
	}
	

	@Override
	public void setRadius(float radius) {
		((ICircle)this.impl).setRadius(radius);
		this.radius = radius;
	}

}
