/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.core.impl;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.geasysvg.core.api.IGroup;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.ISVGElement;
import com.google.gwt.user.client.Element;

public class Group extends SVGElement implements IGroup {

	private HashSet<ISVGElement> children;

	public Group(Element element) {
		super(element);
		this.children = new HashSet<ISVGElement>();
	}

	@Override
	public void translate(float dx, float dy) {
		this.impl.translate(dx, dy);
	}

	public Group(Element element, float x, float y) {
		super(element, x, y);
		this.children = new HashSet<ISVGElement>();
	}

	@Override
	public void appendChild(ISVGElement svgElement) {
		((IGroup) this.impl).appendChild(svgElement);

		this.children.add(svgElement);
		svgElement.setContainer(this);
	}

	@Override
	public HashSet<ISVGElement> getChildren() {
		return children;
	}

	@Override
	public ISVGElement getElementById(String id) {
		for (ISVGElement svgElement : children) {
			if (svgElement.getId().equals(id)) {
				return svgElement;
			}
		}
		return null;
	}

	@Override
	public void setPointerEvents(String pointerEvents) {
		((IGroup) this.impl).setPointerEvents(pointerEvents);
	}

	@Override
	public void removeChild(ISVGElement svgElement) {
		((IGroup) this.impl).removeChild(svgElement);
		this.children.remove(svgElement.getId());
	}

	@Override
	public void setX(float x) {
		this.translate(x, this.getY());
		super.setX(x);
	}

	@Override
	public void setY(float y) {
		this.translate(this.getX(), y);
		super.setY(y);
	}
	
	@Override
	public float getWidth() {
		throw new UnsupportedOperationException("A SVG group has no width. Use the width of its children.");
	}

	@Override
	public float getHeight() {
		throw new UnsupportedOperationException("A SVG group has no height. Use the height of its children.");
	}
}
