/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.core.impl;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.geasysvg.core.api.IMarker;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.ISVGElement;
import com.google.gwt.user.client.Element;

public class Marker extends SVGElement implements IMarker{
	
	private double refX;
	private double refY;
	private HashSet<ISVGElement> children;
	
	public Marker(Element element,String id) {
		super(element);
		
		this.id 		= id;
		this.children 	= new HashSet<ISVGElement>();
		
	}

	@Override
	public double getRefX() {
		return this.refX;
	}

	@Override
	public double getRefY() {
		return this.refY;
	}

	@Override
	public void setRefX(double x) {
		((IMarker)this.impl).setRefX(x);
		this.refX = x;
	}

	@Override
	public void setRefY(double d) {
		((IMarker)this.impl).setRefY(d);
		this.refY = d;
	}

	@Override
	public void appendChild(ISVGElement svgElement) {
		
		((IMarker)this.impl).appendChild(svgElement);
		
		this.children.add(svgElement);
	
	}


	@Override
	public HashSet<ISVGElement> getChildren() {
		return children;
	}


	@Override
	public ISVGElement getElementById(String id) {
		
		for(ISVGElement svgElement:children){
			
			if (svgElement.getId().equals(id)){
				return svgElement;
			}
			
		}
		
		return null;
	}


	@Override
	public void removeChild(ISVGElement svgElement) {
		((IMarker)this.impl).removeChild(svgElement);
		this.children.remove(svgElement.getId());
	}

	@Override
	public void setHeight(float height) {
		((IMarker)this.impl).setHeight(height);
		super.setHeight(height);
	}

	@Override
	public void setWidth(float width) {
		((IMarker)this.impl).setWidth(width);
		super.setWidth(width);
	}

	@Override
	public void setOrient(String orient) {
		((IMarker)this.impl).setOrient(orient);
	}

}
