/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.core.impl;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.geasysvg.core.api.ICircle;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.IGroup;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.IMarker;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.IPath;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.IRectangle;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.ISVGElement;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.IText;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.raphael.SVGDocumentJSNI;
import com.ebmwebsourcing.geasytools.geasysvg.ext.api.ILinearPath;
import com.ebmwebsourcing.geasytools.geasysvg.ext.api.ISVGDocumentExt;
import com.google.gwt.user.client.ui.Widget;

public class SVGDocument extends Widget implements ISVGDocumentExt{
	
	private HashSet<ISVGElement> children;
	
	private float height;
	private float width;
	
	private String desc;

	protected ISVGDocumentExt impl;
	
	private Canvas parentContainer;
	
	public SVGDocument(Canvas parentContainer,int width,int height) {
		
		this.children 			= new HashSet<ISVGElement>();
		this.width 				= width;
		this.height 			= height;
		
		this.parentContainer 	= parentContainer;
		
		this.impl 				= new SVGDocumentJSNI();
		
		setElement(((SVGDocumentJSNI)impl).createCanvas(parentContainer.getElement(), width, height));
		

	}
	

	@Override
	protected void onAttach() {
		
		this.getParent();
		
		//super.onAttach();
		
		
	}

	@Override
	public HashSet<ISVGElement> getChildren() {
		return children;
	}

	
	public Canvas getParentContainer() {
		return parentContainer;
	}
	
	@Override
	public ISVGElement getElementById(String id) {
		
		
		for(ISVGElement svgElement:children){
			
			if (svgElement.getId().equals(id)){
				return svgElement;
			}
			
		}
		
		return null;
	}

	@Override
	public float getHeight() {
		return height;
	}

	@Override
	public float getWidth() {
		return width;
	}

	@Override
	public void removeChild(ISVGElement svgElement) {
		this.impl.removeChild(svgElement);
		this.children.remove(svgElement.getId());
	}

	

	@Override
	public int getAbsoluteLeft() {
		return parentContainer.getAbsoluteLeft();
	}

	@Override
	public int getAbsoluteTop() {
		return parentContainer.getAbsoluteTop();
	}


	@Override
	public ICircle createCircle(float cx, float cy, float radius) {
		
		ICircle circle = this.impl.createCircle(cx, cy, radius); 
		
		circle.setCanvas(this);
		circle.setContainer(this);
		
		return circle;
	}




	@Override
	public IGroup createGroup() {
		
		IGroup group = this.impl.createGroup();
		
		group.setCanvas(this);
		group.setContainer(this);
		
		return group;
	}


	@Override
	public IGroup createGroup(float x,float y) {
		
		IGroup group = this.impl.createGroup();
		
		group.setCanvas(this);
		group.setContainer(this);
		group.setX(x);
		group.setY(y);
		
		return group;
	}
	
	

	@Override
	public IMarker createMarker(String id) {
		
		IMarker marker = this.impl.createMarker(id);
		
		marker.setCanvas(this);
		marker.setContainer(this);
		
		return marker;
	}




	@Override
	public IPath createPath(String path,float x,float y) {
		
		IPath p = this.impl.createPath(path, x, y);
		
		p.setCanvas(this);
		p.setContainer(this);
		
		return p;
	}


	@Override
	public IRectangle createRectangle(float rx, float ry, float width,
			float height) {
		
		IRectangle rect = this.impl.createRectangle(rx, ry, width, height);
		rect.setWidth(width);
		rect.setHeight(height);
		rect.setCanvas(this);
		rect.setContainer(this);
		
		return rect;
	}
	
	
	@Override
	public IRectangle createRectangle(float rx, float ry, float width,
			float height,double cornersRadius) {
		
		IRectangle rect = this.impl.createRectangle(rx, ry, width, height,cornersRadius);
		rect.setWidth(width);
		rect.setHeight(height);
		rect.setCanvas(this);
		rect.setContainer(this);
		
		return rect;
	}


	@Override
	public IText createText(float x, float y, String text) {
		
		IText txt = this.impl.createText(x, y, text);
		
		txt.setCanvas(this);
		txt.setContainer(this);
		
		return txt;
	}


	@Override
	public ILinearPath createLinearPath(float x, float y) {
		
		ILinearPath lPath = this.impl.createLinearPath(x, y);
		
		lPath.setCanvas(this);
		lPath.setContainer(this);
		
		return lPath;
	}

	@Override
	public void setHeight(float height) {
		this.impl.setHeight(height);
		this.height = height;
	}




	@Override
	public void setWidth(float width) {
		this.impl.setWidth(width);
		this.width = width;
	}




	@Override
	public String getDesc() {
		return desc;
	}




	@Override
	public void setDesc(String desc) {

		this.desc = desc;		
	}




	@Override
	public void appendChild(ISVGElement svgElement) {
		this.children.add(svgElement);
		this.impl.appendChild(svgElement);
		svgElement.setContainer(this);
	}







	

}
