/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.core.impl;

import com.ebmwebsourcing.geasytools.geasysvg.core.api.IText;
import com.google.gwt.user.client.Element;

public class Text extends SVGElement implements IText {

	private String font;
	private String fontFamily;
	private int fontSize;
	private String text;

	public Text(Element element, String text, float x, float y) {
		super(element, x, y);

		this.text = text;

	}

	@Override
	public String getFont() {
		return font;
	}

	@Override
	public String getFontFamily() {
		return fontFamily;
	}

	@Override
	public int getFontsize() {
		return fontSize;
	}

	@Override
	public String getText() {
		return text;
	}

	@Override
	public void setFont(String font) {
		((IText) this.impl).setFont(font);
		this.font = font;
	}

	@Override
	public float getWidth() {
		return ((IText) this.impl).getWidth();
	}

	@Override
	public float getHeight() {
		return ((IText) this.impl).getHeight();
	}

	@Override
	public void setFontFamily(String fontFamily) {
		((IText) this.impl).setFontFamily(fontFamily);
		this.fontFamily = fontFamily;
	}

	@Override
	public void setFontSize(int size) {
		((IText) this.impl).setFontSize(size);
		this.fontSize = size;
	}

	@Override
	public void setText(String text) {
		((IText) this.impl).setText(text);
		this.text = text;
	}

	@Override
	public void setX(float x) {
		this.impl.setX(x);
		super.setX(x);
	}

	@Override
	public void setY(float y) {
		this.impl.setY(y);
		super.setY(y);
	}

}
