/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.core.impl.raphael;

import com.ebmwebsourcing.geasytools.geasysvg.core.api.ICircle;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Element;

public class CircleJSNI extends SVGElementJSNI implements ICircle {


	
	protected native Element createCircle(JavaScriptObject raphaelPaper,float cx, float cy, float radius)/*-{
	
		var circle = raphaelPaper.circle(cx,cy,radius);
		
		this.@com.ebmwebsourcing.geasytools.geasysvg.core.impl.raphael.CircleJSNI::setSvgElementJsObject(Lcom/google/gwt/core/client/JavaScriptObject;)(circle);
		
		return circle.node;
	
	}-*/;
	
	
	@Override
	public void setX(float x) {
		
		this.setXJS(getSvgElementJsObject(),x);
		
	}
	
	@Override
	public void setY(float y) {
		
		this.setYJS(getSvgElementJsObject(),y);
		
	}
	
	private native void setXJS(JavaScriptObject svgElement,float x)/*-{
		
		svgElement.attr("cx",x);
		
	}-*/;
	
	
	private native void setYJS(JavaScriptObject svgElement,float y)/*-{
		
		svgElement.attr("cy",y);
		
	}-*/;
	
	@Override
	public float getRadius() {return 0;}
	
	private native void setRadiusJS(JavaScriptObject svgElement,float radius)/*-{
		
		svgElement.attr("r",radius);
		
	}-*/;


	@Override
	public void setRadius(float radius) {
		
		this.setRadiusJS(getSvgElementJsObject(), radius);
		
	}

}
