/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.core.impl.raphael;

import com.ebmwebsourcing.geasytools.geasysvg.core.api.IMarker;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.IPath;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Element;

public class PathJSNI extends SVGElementJSNI implements IPath{
	
	
	
	
	protected native Element createPath(JavaScriptObject raphaelPaper,String path)/*-{
	
		var path = raphaelPaper.path(path);
		
		this.@com.ebmwebsourcing.geasytools.geasysvg.core.impl.raphael.PathJSNI::setSvgElementJsObject(Lcom/google/gwt/core/client/JavaScriptObject;)(path);
		
		return path.node;

	}-*/;

	
	
	/**
	 * Getters
	 */

	@Override
	public IMarker getMarkerEnd() {return null;}

	@Override
	public IMarker getMarkerMid() {return null;}

	@Override
	public IMarker getMarkerStart() {return null;}

	@Override
	public String getPath() {
		return null;
	}
	
	/**
	 * Setters
	 */
	
	@Override
	public void setMarkerEnd(IMarker marker) {
		setMarkerEndJS(getSvgElementJsObject(), marker.getId());
	}

	@Override
	public void setMarkerMid(IMarker marker) {
		setMarkerMidJS(getSvgElementJsObject(), marker.getId());
	}

	@Override
	public void setMarkerStart(IMarker marker) {
		setMarkerStartJS(getSvgElementJsObject(), marker.getId());
	}

	@Override
	public void setPath(String path) {
		
		setPathJS(getSvgElementJsObject(), path);
	}
	
	@Override
	public void setX(float dx) { 
		this.translate(dx, 0);
	}
	
	@Override
	public void setY(float dy) {
		this.translate(0, dy);
	}
	
	/**
	 * JSNI IMPL
	 */
	public native void setMarkerEndJS(JavaScriptObject svgElement,String markerId)/*-{
	
			svgElement.markerEnd(markerId);
	
	}-*/;

	
	public native void setMarkerMidJS(JavaScriptObject svgElement,String markerId)/*-{
	
			svgElement.markerMid(markerId);
	
	}-*/;

	
	public native void setMarkerStartJS(JavaScriptObject svgElement,String markerId)/*-{
	
			svgElement.markerStart(markerId);
	
	}-*/;

	
	public native void setPathJS(JavaScriptObject svgElement,String path)/*-{
	
			svgElement.attr("path",path);
	
	}-*/;
	
	
	
	

}
