/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.ext.impl;

import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Path;
import com.ebmwebsourcing.geasytools.geasysvg.ext.api.ILinearPath;
import com.ebmwebsourcing.geasytools.geasysvg.ext.api.IPoint;
import com.google.gwt.user.client.Element;

public class LinearPath extends Path implements ILinearPath{

	private LinkedHashSet<IPoint> points;
	
	private boolean isSmoothCurve;
	
	public LinearPath(Element element, float x, float y) {
		super(element, "", x, y);
		
		this.points = new LinkedHashSet<IPoint>();
		
		this.isSmoothCurve = false;
		
	}

	
	public LinearPath(Element element,LinkedHashSet<IPoint> points, float x, float y) {
		super(element, "", x, y);
		
		this.points = points;
		
	}
	
	
	@Override
	public void addPoint(IPoint point) {
		this.points.add(point);
	}

	@Override
	public void connectAllPoints() {
		
		//start with point that doesnt have any previous point associated
		IPoint nextPoint = this.getStartPoint();
		
		String path = "M "+nextPoint.getX()+","+nextPoint.getY();
		
		nextPoint = nextPoint.getNextPoint();
		
		while(nextPoint!=null){
			
			IPoint p = nextPoint ;
			
			if (this.isSmoothCurve()==false){
				
				path = path + "L"+p.getX()+","+p.getY();
				
			}else{
				
				double x	=	p.getX() + 20;
				double y	=	p.getY();
				double x2	=	p.getX();
				double y2	=	p.getY() + 2;

				path = path + "S"+x2+","+y2+" "+x+","+y;
			}
			
			nextPoint = nextPoint.getNextPoint();
		}
		
		
		this.setPath(path);
		
	}

	
	
	
	
	@Override
	public LinkedHashSet<IPoint> getPoints() {
		return this.points;
	}

	@Override
	public boolean isSmoothCurve() {
		return isSmoothCurve;
	}

	@Override
	public IPoint getEndPoint() {
		
		for(IPoint p : points){
			
			if (p.getNextPoint()==null){
				return p;
			}
			
		}
		
		return null;
	}

	@Override
	public IPoint getStartPoint() {
		
		for(IPoint p : points){
			
			if (p.getPreviousPoint()==null){
				return p;
			}	
			
		}
		
		
		return null;
	}


	@Override
	public void setSmoothCurve(boolean isSmooth) {
		this.isSmoothCurve = isSmooth;
	}

}
