/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.geasytools.geasyui.impl.core;

import com.ebmwebsourcing.geasytools.geasyui.impl.core.Point;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Util;
import org.junit.Assert;
import org.junit.Test;

public class UtilTest {
    @Test
    public void testFindFn() {
        Point p1 = new Point(20.0f, 10.0f);
        Point p2 = new Point(10.0f, 30.0f);
        Util.LinearFunction fn1 = Util.getInstance().getLinearFunctionFrom2Points(p1, p2);
        Assert.assertTrue((fn1.getA() == -2.0f ? 1 : 0) != 0);
        Assert.assertTrue((fn1.getB() == 50.0f ? 1 : 0) != 0);
        Point p3 = new Point(50.0f, 10.0f);
        Point p4 = new Point(30.0f, 40.0f);
        Util.LinearFunction fn2 = Util.getInstance().getLinearFunctionFrom2Points(p3, p4);
        Assert.assertTrue(((double)fn2.getA() == -1.5 ? 1 : 0) != 0);
        Assert.assertTrue((fn2.getB() == 85.0f ? 1 : 0) != 0);
    }

    @Test
    public void testIntersectionPoint() {
        Point p1 = new Point(20.0f, 10.0f);
        Point p2 = new Point(10.0f, 30.0f);
        Util.LinearFunction fn1 = Util.getInstance().getLinearFunctionFrom2Points(p1, p2);
        Util util = Util.getInstance();
        util.getClass();
        Util.LinearFunction fn2 = new Util.LinearFunction(util, 0.0f, 20.0f);
        Point intersectionPoint = Util.getInstance().getIntesectionPointFromLinearFn(fn1, fn2);
        Assert.assertTrue((intersectionPoint.getX() == 15.0f ? 1 : 0) != 0);
        Assert.assertTrue((intersectionPoint.getY() == 20.0f ? 1 : 0) != 0);
    }

    @Test
    public void testClosestIntersectionPoint() {
        Point p1 = new Point(50.0f, 10.0f);
        Point p2 = new Point(30.0f, 40.0f);
        Point closesPoint1 = Util.getInstance().getClosestIntersectionPointForRectangle(p1, p2, 30, 10, 30, 20);
        Point p3 = new Point(20.0f, 20.0f);
        Point closesPoint2 = Util.getInstance().getClosestIntersectionPointForRectangle(p1, p3, 30, 10, 30, 20);
        Point p4 = new Point(70.0f, 20.0f);
        Point closesPoint3 = Util.getInstance().getClosestIntersectionPointForRectangle(p1, p4, 30, 10, 30, 20);
        Point p5 = new Point(40.0f, 0.0f);
        Point closesPoint4 = Util.getInstance().getClosestIntersectionPointForRectangle(p1, p5, 30, 10, 30, 20);
        Assert.assertTrue(((int)closesPoint1.getX() == 36 && closesPoint1.getY() == 30.0f ? 1 : 0) != 0);
        Assert.assertTrue((closesPoint2.getX() == 30.0f && closesPoint2.getY() == 16.0f ? 1 : 0) != 0);
        Assert.assertTrue((closesPoint3.getX() == 60.0f && closesPoint3.getY() == 15.0f ? 1 : 0) != 0);
        Assert.assertTrue((closesPoint4.getX() == 50.0f && closesPoint4.getY() == 10.0f ? 1 : 0) != 0);
    }
}

