/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.draggable;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IMouseState;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDropProxyIndicator;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.AcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.AcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.RefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.RefusedBeforeDropEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Image;


/**
 * The only thing that interest us here are the events
 * that current proxy may receive. 
 * 
 * @author nfleury
 *
 */
public class DraggableProxy extends AbsolutePanel implements IDragProxy{
	
	private HandlerManager handlerManager;
	private IHasDragProxy hasProxy;
	private String proxyImageUrl;
	
	
	public DraggableProxy(IHasDragProxy hasProxy) {
		
		this.hasProxy = hasProxy;
		
		this.handlerManager = new HandlerManager(this);
		
		if (this.hasProxy.getProxyImgUrl()!=null){
			
			this.add(new Image(hasProxy.getProxyImgUrl()));
			
		}
		
	}
	
	@Override
	public void addDragHandler(IDragHandler dragHandler) {
		handlerManager.addHandler(DragStartEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(DragMoveEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(DragStopEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(AcceptedBeforeDropEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(AcceptedAfterDropEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(RefusedBeforeDropEvent.TYPE,(DragHandler)dragHandler);
		handlerManager.addHandler(RefusedAfterDropEvent.TYPE,(DragHandler)dragHandler);
	}

	@Override
	public IContainer getContainer() {
		return getUIPanel();
	}

	@Override
	public IDraggableElementDefaultHandlers getDraggableElementDefaultHandlers() {
		return null;
	}

	@Override
	public HandlerManager getHandlerManager() {
		return handlerManager;
	}

	@Override
	public String getId() {
		return "DragProxy";
	}

	@Override
	public IMouseState getMouseState() {return null;}

	@Override
	public float getRelativeX() {
		return this.getAbsoluteLeft()-this.getUIPanel().getAbsoluteLeft();
	}

	@Override
	public float getRelativeY() {
		return this.getAbsoluteTop()-this.getUIPanel().getAbsoluteTop();
	}

	@Override
	public IUIPanel getUIPanel() {
		return hasProxy.getUIPanel();
	}

	@Override
	public void setContainer(IContainer container) {
		// TODO Auto-generated method stub
		
	}

	
	@Override
	public void fireEvent(GwtEvent<?> event) {
		super.fireEvent(event);
		handlerManager.fireEvent(event);
	}
	
	@Override
	public void setRelativeX(float x) {}

	@Override
	public void setRelativeY(float y) {}

	@Override
	public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {return null;}

	@Override
	public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
		return addDomHandler(handler, MouseUpEvent.getType()) ;
	}

	@Override
	public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {return null;}

	@Override
	public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {return null;}

	@Override
	public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {return null;}

	@Override
	public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {return null;}



	@Override
	public IHasDragProxy getHasDraggableElementProxy() {
		return hasProxy;
	}

	@Override
	public HashSet<Class<? extends IUIElement>> getDraggedTypes() {
		return hasProxy.getDraggedTypes();
	}

	@Override
	public IDropProxyIndicator getIndicator() {
		return null;
	}



}
