/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.palette;

import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.palette.IPalette;
import com.ebmwebsourcing.geasytools.geasyui.api.palette.IPaletteGroup;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;

public class Palette extends Composite implements IPalette{
	
	private AbsolutePanel mainPanel;
	private LinkedHashSet<IPaletteGroup> groups;
	
	private IUIPanel panel;
	
	public Palette(IUIPanel panel) {
		
		this.panel 		= panel;
		this.mainPanel 	= new AbsolutePanel();
		this.groups    	= new LinkedHashSet<IPaletteGroup>();
		
		initWidget(mainPanel);
		this.setStyleName("ui-palette");
	}
	
	@Override
	public void addGroup(IPaletteGroup group) {
		this.mainPanel.add((Widget) group);
		this.groups.add(group);
	}

	@Override
	public LinkedHashSet<IPaletteGroup> getGroups() {
		return groups;
	}

	@Override
	public IUIPanel getUIPanel() {
		return panel;
	}

	@Override
	public void setUIPanel(IUIPanel panel) {
		this.panel = panel;
		
		//change panel ref of every elements
		for(IPaletteGroup g:groups){
			
			for(IHasDragProxy p : g.getElements()){
				
				p.setUIPanel(panel);
				
			}
			
			
		}
		
	}

}
