/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.resizable;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IMouseState;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.IDroppableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.IResizable;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.IResizableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.IResizeUIHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Helper;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.MouseState;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.UIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DraggableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.AcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.AcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.RefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.RefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.resizable.events.ResizeEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.resizable.events.ResizeStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.resizable.events.ResizeStopEvent;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.RootPanel;

public class ResizeUIHandler extends AbsolutePanel implements IResizeUIHandler,DragHandler{
	

	private IResizable resizableElement;
	
	private HandlerManager handlerManager;
	private MouseState mouseState;
	private IDraggableElementDefaultHandlers draggableDefaultHandlers;
	
	private AbsolutePanel abspanel;
	
	public ResizeUIHandler(IResizable resizableElement) {
	
		
		this.resizableElement 	= resizableElement;
		this.handlerManager 	= new HandlerManager(this);
		this.mouseState			= new MouseState();
		this.draggableDefaultHandlers = new DraggableElementDefaultHandlers(this);
		
		this.addDragHandler(this);
		
		this.setStyleName("resizable-handler");
		this.setPixelSize(10, 10);
		
		this.getElement().setId(DOM.createUniqueId());
		
		if (resizableElement.getUIPanel() instanceof UIPanel){
			
			this.abspanel   = Helper.getAbsolutePanel(resizableElement); 
		
		}else{
			throw new IllegalStateException("UIPanel is not instance of "+AbsolutePanel.class+ " cannot add resizable handler to UIPanel.");
		}
	
		
	}
	
	
	@Override
	public void addDragHandler(IDragHandler dragHandler) {
		handlerManager.addHandler(DragStartEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(DragMoveEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(DragStopEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(AcceptedBeforeDropEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(AcceptedAfterDropEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(RefusedBeforeDropEvent.TYPE,(DragHandler)dragHandler);
		handlerManager.addHandler(RefusedAfterDropEvent.TYPE,(DragHandler)dragHandler);
	}

	@Override
	public IContainer getContainer() {
		return resizableElement.getUIPanel();
	}

	@Override
	public IDraggableElementDefaultHandlers getDraggableElementDefaultHandlers() {
		return draggableDefaultHandlers;
	}


	@Override
	public HandlerManager getHandlerManager() {
		return handlerManager;
	}

	@Override
	public String getId() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IMouseState getMouseState() {
		return mouseState;
	}

	@Override
	public IUIPanel getUIPanel() {
		return resizableElement.getUIPanel();
	}

	public float getRelativeX() {
		return this.getAbsoluteLeft() - this.getContainer().getAbsoluteLeft();
	}

	@Override
	public float getRelativeY() {
		return this.getAbsoluteTop() - this.getContainer().getAbsoluteTop();
	}

	@Override
	public void setContainer(IContainer container) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void setRelativeX(float x) {
		abspanel.setWidgetPosition(this, (int)x+getUIPanel().getScrollLeft(), (int)this.getRelativeY());		
	}

	@Override
	public void setRelativeY(float y) {
		abspanel.setWidgetPosition(this, (int)getRelativeX(), (int)y);
	}


	@Override
	public void fireEvent(GwtEvent<?> event) {
		super.fireEvent(event);
		handlerManager.fireEvent(event);
	}

	@Override
	public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
		return addDomHandler(handler, MouseDownEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
		return addDomHandler(handler, MouseUpEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
		return addDomHandler(handler, MouseOutEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
		return addDomHandler(handler, MouseOverEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
		return addDomHandler(handler, MouseMoveEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
		return addDomHandler(handler, MouseWheelEvent.getType());
	}




	@Override
	public IResizableElement getResizableElement() {
		return resizableElement;
	}


	@Override
	public void onMove(IDragMoveEvent event) {
		
		resizableElement.fireEvent(new ResizeEvent());
		
	}


	@Override
	public void onStart(IDragStartEvent event) {
		
		resizableElement.fireEvent(new ResizeStartEvent());
		
	}


	@Override
	public void onStop(IDragStopEvent event) {
		
		int newWidth 	= (int) (this.getRelativeX() - event.getDragStartX());
		int newHeight	= (int) (this.getRelativeY() - event.getDragStartY()); 
		
		newWidth 		= (int) (newWidth 	+ resizableElement.getWidth());
		newHeight 		= (int) (newHeight 	+ resizableElement.getHeight());

		resizableElement.setWidth(newWidth);
		resizableElement.setHeight(newHeight);
		
		((ResizableElementDefaultHandlers)resizableElement.getResizableDefaultHandlers()).refreshUIHandlersPositions();
	
		resizableElement.fireEvent(new ResizeStopEvent());
	}


	@Override
	public HashSet<Class<? extends IUIElement>> getDraggedTypes() {
		
		HashSet<Class<? extends IUIElement>> draggedTypes = new HashSet<Class<? extends IUIElement>>();
		
		//draggedTypes.add(this.getClass());
		
		return draggedTypes;
	}


	@Override
	public void onAcceptedAfterDrop(IAcceptedAfterDropEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onAcceptedBeforeDrop(IAcceptedBeforeDropEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onRefusedAfterDrop(IRefusedAfterDropEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onRefusedBeforeDrop(IRefusedBeforeDropEvent event) {
		// TODO Auto-generated method stub
		
	}

}
