/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.uipanel;

import java.util.Collection;
import java.util.HashMap;

import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.selectable.ISelectable;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IPanelSelectorDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Point;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Region;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.GlobalDragData;
import com.ebmwebsourcing.geasytools.geasyui.impl.selectable.events.SelectEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.ScrollEvent;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.RootPanel;

/**
 * Adds the events and boring calculations 
 * stuffs for selection ability on an UIPanel
 * 
 * @author nfleury
 */
@SuppressWarnings("unchecked")
public class UIPanelSelectorDefaultHandlers implements IPanelSelectorDefaultHandlers {
	
	private IUIPanel panel;
	
	private SelectorArtifact selectorArtifact;//the concrete HTML manipulated widget
	private Region selector;//representation of selector with coordinates
	
	private SelectionMarker selectionMarker;
	
	private int selectorInitX;
	private int selectorInitY;

	
	
	public UIPanelSelectorDefaultHandlers(IUIPanel panel) {
		
		this.panel = panel;
		
		this.attachListeners();
		
	}

	private void attachListeners() {
		

		
		//watch mouse movement relatively to the UIPanel
		this.panel.addMouseMoveHandler(new MouseMoveHandler() {
			
			@Override
			public void onMouseMove(MouseMoveEvent arg0) {
				
				//System.out.println("SELECTOR MOUSE MOVE ");
				
				if (selectorArtifact!=null && panel.getMouseState().isMouseDown()){
					
					int width 	= (arg0.getClientX()-panel.getAbsoluteLeft()+panel.getScrollLeft())+Window.getScrollLeft() - selectorInitX;
					int height 	= (arg0.getClientY()-panel.getAbsoluteTop()+panel.getScrollTop())+Window.getScrollTop() - selectorInitY;
				
					
					//dragging cursor in SE direction
					if (width>0 && height>0){
						
						selectorArtifact.setPixelSize(width, height);
						
						
	
					//dragging cursor in NW direction						
					}else if (width<0 && height<0){
						
						int newWidth  = width * -1;
						int newHeight = height * -1;
						
						
						selectorArtifact.setPixelSize(newWidth, newHeight);
						

						panel.setSelector(selectorArtifact, (arg0.getClientX()-panel.getAbsoluteLeft()+panel.getScrollLeft())+Window.getScrollLeft(), (arg0.getClientY()-panel.getAbsoluteTop())+panel.getScrollTop()+Window.getScrollTop());

					
					//dragging cursor in NE direction	
					} else if (height<0 && width>0) {
						
						int newHeight = height *-1;
						
						selectorArtifact.setPixelSize(width, newHeight);
						
						panel.setSelector(selectorArtifact, selectorInitX, selectorInitY-newHeight );
												
						
					//dragging cursor in SW direction
					} else if(height>0 && width<0) {
						
						int newWidth = width *-1;
						
						selectorArtifact.setPixelSize(newWidth, height);
						
						panel.setSelector(selectorArtifact, selectorInitX-newWidth, selectorInitY );
						

					}
					
					//set selector region
					selector = new Region(new Point(selectorArtifact.getAbsoluteLeft(), selectorArtifact.getAbsoluteTop()),
							new Point(selectorArtifact.getAbsoluteLeft()+selectorArtifact.getOffsetWidth(), selectorArtifact.getAbsoluteTop()+selectorArtifact.getOffsetHeight()));
					
					
				}
				
				

			}
		});
		
		
		this.panel.addMouseDownHandler(new MouseDownHandler() {
			
			@Override
			public void onMouseDown(MouseDownEvent arg0) {
				
				//only create selector if it is in
				//actual uipanel region => excludes scrollbar
				//use absolute values to compare
				Region uipanelRegion = new Region(new Point(panel.getAbsoluteLeft(),panel.getAbsoluteTop())
						,new Point(panel.getAbsoluteLeft()+panel.getClientWidth(), panel.getAbsoluteTop()+panel.getClientHeight()));
				
				
				boolean uiPanelRegionContainsMouse = uipanelRegion.contains(new Point(arg0.getClientX()+Window.getScrollLeft(),arg0.getClientY()+Window.getScrollTop()));
				
				if (selectorArtifact==null && uiPanelRegionContainsMouse){
					
					selectorArtifact = new SelectorArtifact();
					selectorArtifact.setStyleName("ui-selector");
					selectorInitX = (arg0.getClientX()-panel.getAbsoluteLeft()+panel.getScrollLeft())+Window.getScrollLeft();
					selectorInitY =	(arg0.getClientY()-panel.getAbsoluteTop()+panel.getScrollTop())+Window.getScrollTop();

//					System.out.println("selector init x:"+selectorInitX+" inti y:"+ selectorInitY);
					// is for damned IE !! - otherwise mouse overlaps selector and panel doesnt receive the mouseup event  
					//doesnt have a major impact on FireFox
					//TODO: check if doesnt impact other browsers
					//RootPanel.get().add(selectorArtifact, arg0.getClientX()+Window.getScrollLeft(), arg0.getClientY()+Window.getScrollTop());
					panel.setSelector(selectorArtifact, selectorInitX-3, selectorInitY-3);
				}
				
				panel.getMouseState().setMouseDown(true);
				
			}
		});
		
		this.panel.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				//System.out.println("SELECTOR CLICK");	
				//first unselect all selected elements
				panel.unSelectAllEments();
				
				if (selectionMarker!=null){
					panel.removeSelectionMarker();
					selectionMarker = null;
				}
				
				if (selector !=null){
					//each time user release the mouse
					
					//-DO SELECTION 
					//we check if the selector contains one of the intersection points
					HashMap<String, ISelectable> selectedElements = new HashMap<String, ISelectable>();
					
					for(IUIElement uiE:(Collection<IUIElement>)panel.getUIElements().values()){
						
						if (uiE instanceof ISelectable){
							
							ISelectable selectable = (ISelectable) uiE;
							
							//TODO: change the way this is made
							if (selectableIsInSeletion(selectable) && selectable.getContainer() instanceof IUIPanel){
							
								selectedElements.put(selectable.getId(), selectable);
							
							}

						}

					}
					
					//set selection on UIPanel
					getUIPanel().setSelectedElements(selectedElements);
					
					
					
					//- ADD SELECTION MARKER FOR MULTIPLE SELECTION
					//if current selection just selected more than
					//one element add a selector marker around the selected elements
					//if (panel.getSelectedElements().size()>1){
						selectionMarker = new SelectionMarker(panel);

						selectionMarker.load();
					//}
					

				}
				
				//REMOVE SELECTOR ELEMENT
				if (selectorArtifact!=null){
					panel.removeSelector();
					selectorArtifact = null;
				}
				
				if (selector !=null) selector = null;
				
			}
		});
		


		
		

		
	}
	
	
	private boolean selectableIsInSeletion(ISelectable selectable){
		
		for(Point p:selectable.getIntersectionPoints().values()){
			
			if (selector.contains(p)){

				return true;
			}

		}
		
		return false;
	}

	@Override
	public void attachDefaultHandlers() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public IUIPanel getUIPanel() {
		return panel;
	}


	
	
}
