/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.uipanel.events;


import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IResizeRequestEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUIPanelHandler;
import com.google.gwt.event.shared.GwtEvent;

public class ResizeRequestEvent extends GwtEvent<IUIPanelHandler> implements IResizeRequestEvent{
	
	public static Type<IUIPanelHandler> TYPE= new Type<IUIPanelHandler>();
	
	private int increaseWidthSize;
	private int increaseHeightSize;
	private int decreaseWidthSize;
	private int decreaseHeightSize;
	
	public ResizeRequestEvent(int increaseWidthSize,int increaseHeightSize,int decreaseWidthSize,int decreaseHeightSize) {
		
		this.increaseWidthSize = increaseWidthSize;
		this.increaseHeightSize = increaseHeightSize;
		this.decreaseWidthSize = decreaseWidthSize;
		this.decreaseHeightSize = decreaseHeightSize;
		
	}
	
	@Override
	protected void dispatch(IUIPanelHandler handler) {
		handler.onResizeRequest(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IUIPanelHandler> getAssociatedType() {
		return TYPE;
	}

	

	@Override
	public int getDecreaseHeightSize() {
		return decreaseHeightSize;
	}

	@Override
	public int getDecreaseWidthSize() {
		return decreaseWidthSize;
	}

	@Override
	public int getIncreaseHeightSize() {
		return increaseHeightSize;
	}

	@Override
	public int getIncreaseWidthSize() {
		return increaseWidthSize;
	}


	
	
}
