/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.api.core;

import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.google.gwt.event.shared.HasHandlers;

public interface IUIElement extends IPositionable,IGraphicElement,HasHandlers{
	
	String getId();
	
	String getName();
	
	IUIPanel getUIPanel();
	
	void setUIPanel(IUIPanel uiPanel);
	
	float getRelativeX();
	
	float getRelativeY();
	
	void setRelativeX(float x);
	
	void setRelativeY(float y);
	
	float getWidth();
	
	float getHeight();
	
	void setWidth(float width);
	
	void setHeight(float width);
	
	IMouseState getMouseState();
	
	
	/**
	 * The container is the element from with current
	 * element cannot be taken off. This value can never be null. 
	 * Default value is always {@link IUIPanel}
	 * 
	 * @param container
	 */
	void setContainer(IContainer container);
	
	IContainer getContainer();
	

	
}
